// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: lazyvec.h 813 2011-09-10 12:31:51Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_LAZY_VEC_H
#define COMMON_LAZY_VEC_H

#include <vector>
#include <inttypes.h>

template<class T>
class LazyVec {
private:
    typedef typename std::vector<T> vec_t;
    vec_t vec;
    uint32_t last;
public:
    LazyVec() : 
	last(0) 
	{}

    LazyVec(uint32_t size) : 
	vec(size), 
	last(size-1) 
	{}
    
    LazyVec(uint32_t size, const T& t) : 
	vec(size, t), 
	last(size-1) 
	{}
    
    bool empty() const { 
	return last == 0; 
    }
    
    uint32_t size() const { 
	return last; 
    }
    
    void clear() { 
	last = 0; 
    }

    void push_back(const T& t) {
	if (vec.size() == last) {
	    vec.push_back(t);
	} else {
	    vec[last] = t;
	}
	last++;
    }
    
    const T& operator[](uint32_t index) const {
	return vec[index];
    }
    
    T& operator[](uint32_t index) {
	return vec[index];
    }
};

#endif /* COMMON_LAZY_VEC_H */
