// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: hash.h 813 2011-09-10 12:31:51Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_HASH_H
#define COMMON_HASH_H

#include <inttypes.h>

// Shift-Add-XOR hash
template<class ForwardIterator>
static inline uint32_t sax_hash(ForwardIterator beg, ForwardIterator end, uint32_t key=0) {
    for ( ; beg != end; ++beg) {
	key ^= ( key << 5 ) + ( key >> 2 ) + *beg;
    }
    return key;
}

// Rotating hash
template<class ForwardIterator>
static inline uint32_t rot_hash(ForwardIterator beg, ForwardIterator end, uint32_t key=0) {
    for ( ; beg != end; ++beg) {
	key = ( key << 4 ) ^ ( key >> 28 ) ^ *beg;
    }
    return key;
}

// Bernstein hash
template<class ForwardIterator>
static inline uint32_t djb_hash(ForwardIterator beg, ForwardIterator end, uint32_t key=0) {
    for ( ; beg != end; ++beg) {
	key = 33 * key + *beg;
    }
    return key;
}

#endif /* COMMON_HASH_H */
