// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: flyweight.h 924 2014-10-06 13:28:52Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_FLYWEIGHT_H
#define COMMON_FLYWEIGHT_H

#include <inttypes.h>
#include <utility>
#include <vector>

template<class T>
class Flyweight {
private:
    typedef typename std::vector<T*> vec_t;
    typedef typename vec_t::iterator iterator;
    typedef typename vec_t::const_iterator const_iterator;
    vec_t data;

public:
    Flyweight() {}

    std::pair<T*, bool> insert(T* elem) {
	for (uint32_t i = 0; i < data.size(); i++) {
	    if (*data[i] == *elem) {
		delete elem;
		return std::make_pair(data[i], false);
	    }
	}
	data.push_back(elem);
	return std::make_pair(data.back(), true);
    }    
    
    uint32_t size() const { return data.size(); }
};

#endif /* COMMON_FLYWEIGHT_H */
