// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: idmapper.h 942 2016-05-27 12:58:52Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef ID_MAPPER_H
#define ID_MAPPER_H

#include "causalgraph/cg_variable.h"
#include <inttypes.h>
#include <map>
#include <iosfwd>

class IDMapper {
public:
    typedef std::pair<cg::VarType, int> key_t;
private:
    static const int32_t NOT_FOUND = -1;

    typedef std::pair<key_t, int> entry_t;
    typedef std::map<key_t, int> map_t;
    typedef std::map<int, key_t> imap_t;

    map_t loc2glob;          // maps local ids of variables to global cg-ids
    mutable imap_t glob2loc; // inverse of above

    void update() const;
public:

    int& operator()(cg::VarType type, int localID);
    const int& operator()(cg::VarType type, int localID) const;
    const key_t& operator()(int globalID) const;
    std::ostream& display(std::ostream& o) const;
};

inline std::ostream& operator<<(std::ostream& o, const IDMapper& mapper) {
    return mapper.display(o);
}

#endif /* ID_MAPPER_H */
