// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: idmapper.cpp 942 2016-05-27 12:58:52Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "causalgraph/idmapper.h"

#include "common/message.h"

#include <cassert>
#include <iostream>
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH

using namespace std;

void IDMapper::update() const {
    foreach(const entry_t& entry, loc2glob) {
        glob2loc.insert(make_pair(entry.second, entry.first));
    }
}

int& IDMapper::operator()(cg::VarType type, int localID) {
    return loc2glob.insert(make_pair(key_t(type, localID), NOT_FOUND)).first->second;
}

const int& IDMapper::operator()(cg::VarType type, int localID) const {
    return loc2glob.find(key_t(type, localID))->second;
}

const IDMapper::key_t& IDMapper::operator()(int globalID) const {
    imap_t::const_iterator pos = glob2loc.find(globalID);
    if (pos == glob2loc.end()) {
        update();
        pos = glob2loc.find(globalID);
        assert(pos != glob2loc.end());
    }
    return pos->second;
}

ostream& IDMapper::display(ostream& o) const {
    foreach(const entry_t& entry, loc2glob) {
        o << "(" << entry.first.first << "," << entry.first.second << ") -> " << entry.second << endl;
    }
    return o;
}
