// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: cg_variable.h 942 2016-05-27 12:58:52Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef CG_VARIABLE_H
#define CG_VARIABLE_H

// #include "causalgraph/typedefs.h"
#include <string>
#include <iosfwd>
#include <inttypes.h>

// A variable is either an integer variable, a variable for the
// current location of the parallel processes, or a clock variable
// Currently, no clock variables are supported

namespace cg {
enum VarType {
    UNDEF = 0,
    GLOBAL_INTEGER,
    GLOBAL_CLOCK,
    PROCESS,
    LOCAL_INTEGER,
    LOCAL_CLOCK
};

class CGVariable {
public:
    int32_t lower;
    int32_t upper;
    std::string name;
    int32_t level;
    bool necessary;
    VarType type;
    int32_t id;
    int32_t system_id;

    CGVariable(const std::string& name, int32_t lower, int32_t upper, VarType type);

    bool is_integer_var() const;
    std::ostream& display(std::ostream& o) const;

    bool operator==(const CGVariable& other) const {return name == other.name; }
    bool operator!=(const CGVariable& other) const {return !(*this == other); }
};

inline std::ostream& operator<<(std::ostream& o, const CGVariable& var) {
    return var.display(o);
}
}

#endif
