// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: cg_variable.cpp 942 2016-05-27 12:58:52Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "causalgraph/cg_variable.h"

#include <iostream>
#include <cassert>

using namespace std;

namespace cg {
CGVariable::CGVariable(const string& name, int32_t lower, int32_t upper, VarType type) :
    lower(lower),
    upper(upper),
    name(name),
    level(-1),
    necessary(false),
    type(type),
    id(-1),
    system_id(-1)
{}

ostream& CGVariable::display(ostream& o) const {
    return o << name;
}

bool CGVariable::is_integer_var() const {
    return type == GLOBAL_INTEGER || type == LOCAL_INTEGER;
}

// void CGVariable::set_level(int32_t theLevel) {
//      assert(level == -1);
//      level = theLevel;
// }

// int32_t CGVariable::get_level() const {
//      return level;
// }

// void CGVariable::set_necessary() {
//      assert(necessary == false);
//      necessary = true;
// }

// bool CGVariable::is_necessary() const {
//      return necessary;
// }

// int32_t CGVariable::get_upper() const {
//      return upper;
// }

// int32_t CGVariable::get_lower() const {
//      return lower;
// }
}
