// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: cg_operator.h 942 2016-05-27 12:58:52Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef CG_OPERATOR_H
#define CG_OPERATOR_H

#include "causalgraph/idmapper.h"

#include <iosfwd>
#include <vector>

class Edge;
class IntAssignment;
class IntConstraint;

namespace cg {
class CGVariable;

class CGOperator {
private:
    IDMapper procid_to_varid;

    void getSourceVariablesForEdge(const Edge* edge, const std::vector<CGVariable*>& all_variables, std::vector<CGVariable*>& variables) const;
    void getDestinationVariablesForEdge(const Edge* edge, const std::vector<CGVariable*>& all_variables, std::vector<CGVariable*>& variables) const;

public:
    Edge* edge1;
    Edge* edge2;

    CGOperator(Edge* edge1, Edge* edge2, const IDMapper& procid_to_varid);

    std::vector<CGVariable*> getSourceVariables(const std::vector<CGVariable*>& all_variables) const;
    std::vector<CGVariable*> getDestinationVariables(const std::vector<CGVariable*>& all_variables) const;
    void getIntegerAssignments(std::vector<const IntAssignment*>& integerassignments) const;
    void getIntegerConstraints(std::vector<const IntConstraint*>& integerconstraints) const;

    bool is_tau_operator() const {return edge2 == NULL; }

    std::ostream& display(std::ostream& o) const;
};

inline std::ostream& operator<<(std::ostream& o, const CGOperator& op) {
    return op.display(o);
}
}

#endif
