find_program(GPERF_EXECUTABLE gperf DOC "path to the gperf executable")
mark_as_advanced(GPERF_EXECUTABLE)

if (GPERF_EXECUTABLE)
  # the gperf commands should be executed with the C locale, otherwise
  # the message (which are parsed) may be translated
  set(_GPERF_SAVED_LC_ALL "$ENV{LC_ALL}")
  set(ENV{LC_ALL} C)

  execute_process(COMMAND ${GPERF_EXECUTABLE} --version
    OUTPUT_VARIABLE GPERF_version_output
    ERROR_VARIABLE GPERF_version_error
    RESULT_VARIABLE GPERF_version_result
    OUTPUT_STRIP_TRAILING_WHITESPACE)

  set(ENV{LC_ALL} ${_GPERF_SAVED_LC_ALL})

 if (NOT ${GPERF_version_result} EQUAL 0)
   message(SEND_ERROR "Command \"${GPERF_EXECUTABLE} --version\" failed with output:\n${GPERF_version_error}")
 else()
   string(REGEX REPLACE "^GNU gperf ([^\n]+)\n.*" "\\1"
     GPERF_VERSION "${GPERF_version_output}")
 endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(GPERF 
  REQUIRED_VARS  
  GPERF_EXECUTABLE
  VERSION_VAR 
  GPERF_VERSION)