#! /usr/bin/env python
# -*- coding: utf-8 -*-

import re
import os.path
import sys
import logging

logger = logging.getLogger("config")

class ProgramNotFoundException(Exception):
    def __init__(self, msg):
        self.msg = msg
    def __str__(self):
        return repr(self.msg)

def check(filename):
    progs = {}
    for line in open(filename):
        m = re.match(r'^(.*) *= *"(.*)"', line)
        if m:
            progs[m.group(1).strip()] = os.path.expanduser(m.group(2))
    for prog, cmd in progs.iteritems():
        if not os.path.exists(cmd):
            msg = "Error '%s' does not exist" % cmd
            logger.error(msg)
            raise ProgramNotFoundException(msg)
        setattr(sys.modules[__name__], prog, cmd)

check("./config")




