#line 2 "lexer.cc"

#line 4 "lexer.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE utap_restart(utap_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int utap_leng;

extern FILE *utap_in, *utap_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up utap_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up utap_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via utap_restart()), so that the user can continue scanning by
	 * just pointing utap_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when utap_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int utap_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow utap_wrap()'s to do buffer switches
 * instead of setting up a fresh utap_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void utap_restart (FILE *input_file  );
void utap__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE utap__create_buffer (FILE *file,int size  );
void utap__delete_buffer (YY_BUFFER_STATE b  );
void utap__flush_buffer (YY_BUFFER_STATE b  );
void utap_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void utap_pop_buffer_state (void );

static void utap_ensure_buffer_stack (void );
static void utap__load_buffer_state (void );
static void utap__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER utap__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE utap__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE utap__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE utap__scan_bytes (yyconst char *bytes,int len  );

void *utap_alloc (yy_size_t  );
void *utap_realloc (void *,yy_size_t  );
void utap_free (void *  );

#define yy_new_buffer utap__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        utap_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            utap__create_buffer(utap_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        utap_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            utap__create_buffer(utap_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *utap_in = (FILE *) 0, *utap_out = (FILE *) 0;

typedef int yy_state_type;

extern int utap_lineno;

int utap_lineno = 1;

extern char *utap_text;
#define yytext_ptr utap_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up utap_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	utap_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 77
#define YY_END_OF_BUFFER 78
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[102] =
    {   0,
        0,    0,    0,    0,   78,   76,    7,    9,   76,   23,
       44,   46,   22,   19,   20,   42,   40,   12,   41,   11,
       43,   75,   14,   13,   56,   26,   57,   21,   62,   74,
       74,   63,   64,   17,   76,   18,   47,   15,   45,   16,
        4,    1,    4,    4,    7,    9,   10,   59,   32,   51,
       34,   30,   60,   28,   61,   29,   24,    0,    8,    6,
       31,   75,   27,   48,   52,   38,   54,   58,   55,   53,
       49,   39,   74,    0,   66,   68,    0,    0,   70,   72,
        0,    0,    5,   35,   33,   50,    2,    3,    0,   73,
        0,    6,   36,   37,   65,   67,   69,   71,    3,   25,

        0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    1,    6,    6,    7,    8,    9,   10,
       11,   12,   13,   14,   15,   16,   17,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   19,   20,   21,
       22,   23,   24,    1,   25,   26,   26,   26,   27,   28,
       29,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   30,   26,   31,   26,   26,   26,
       32,   33,   34,   35,   26,    1,   26,   26,   26,   26,

       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   36,   26,   26,   26,
       26,   26,   37,   38,   39,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[40] =
    {   0,
        1,    1,    2,    1,    1,    3,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    3,    1,    1,
        3,    1,    1,    1,    3,    3,    3,    3,    3,    3,
        3,    3,    1,    1,    1,    3,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[106] =
    {   0,
        0,    0,   37,   38,  115,  116,  112,  110,  109,   89,
       88,   34,  116,  116,  116,   87,   30,  116,   36,  116,
       45,   90,   85,  116,   23,   42,   46,  116,   45,   39,
       54,    0,    0,  116,   76,  116,   84,  116,   54,  116,
      116,  116,   88,   87,  101,   99,   96,  116,  116,  116,
      116,  116,  116,  116,   74,  116,  116,   76,  116,    0,
      116,   72,  116,   67,  116,  116,  116,  116,  116,  116,
       66,  116,    0,   64,    0,    0,   51,   61,    0,    0,
       27,   78,  116,  116,  116,  116,  116,    0,   50,  116,
       25,    0,  116,  116,  116,  116,  116,  116,    0,  116,

      116,   92,   43,   95,   98
    } ;

static yyconst flex_int16_t yy_def[106] =
    {   0,
      101,    1,  102,  102,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  103,  103,
      103,   30,   30,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  104,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,   30,  101,   30,   30,  101,  101,   30,   30,
      101,  101,  101,  101,  101,  101,  101,  105,  101,  101,
      101,  104,  101,  101,  101,  101,  101,  101,  105,  101,

        0,  101,  101,  101,  101
    } ;

static yyconst flex_int16_t yy_nxt[156] =
    {   0,
        6,    7,    8,    9,   10,    6,   11,   12,   13,   14,
       15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
       25,   26,   27,   28,   29,   30,   31,   30,   30,   32,
       33,   34,   35,   36,   37,   30,   38,   39,   40,   42,
       42,   50,   53,   64,   65,   73,   66,  100,   43,   43,
       55,   54,   47,   44,   44,   51,   59,   56,   57,  101,
       98,   60,   67,   68,   69,   74,   61,   70,   71,   72,
      101,   58,   75,   76,   78,   85,   77,   82,   83,   82,
       83,   79,   80,   97,   96,   81,   95,   94,   93,   62,
       91,   86,   41,   41,   41,   92,   90,   92,   99,   89,

       99,   46,   45,   88,   87,   84,   63,   62,   52,   49,
       48,   47,   46,   45,  101,    5,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101
    } ;

static yyconst flex_int16_t yy_chk[156] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
        4,   12,   17,   25,   25,  103,   25,   91,    3,    4,
       19,   17,   89,    3,    4,   12,   21,   19,   19,   30,
       81,   21,   26,   26,   26,   29,   21,   27,   27,   27,
       30,   19,   29,   29,   31,   39,   29,   35,   35,   82,
       82,   31,   31,   78,   77,   31,   74,   71,   64,   62,
       58,   39,  102,  102,  102,  104,   55,  104,  105,   47,

      105,   46,   45,   44,   43,   37,   23,   22,   16,   11,
       10,    9,    8,    7,    5,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int utap__flex_debug;
int utap__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *utap_text;
#line 1 "lexer.ll"
/* libutap - Uppaal Timed Automata Parser.
   Copyright (C) 2002 Uppsala University and Aalborg University.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
*/
#line 24 "lexer.ll"

#include <iostream>
#include "keywords.cc"
#include "libparser.h"

using std::ostream;
  
#define YY_DECL int lexer_flex(void)

uint32_t PositionTracker::line;
uint32_t PositionTracker::offset;
uint32_t PositionTracker::position = 0;
std::string PositionTracker::path;

namespace UTAP 
{
  void PositionTracker::setPath(UTAP::ParserBuilder *parser, std::string s) {

    // Incrementing the position by one avoids the problem where the
    // end-position happens to bleed into a path. E.g. the range 5-10
    // contains 5 character (at positions 5, 6, 7, 8 and 9), thus
    // position 10 could have a new path). An alternative would be to
    // subtract 1 before calling Positions::find().

    position++; 
    line = 1;
    offset = 0;
    path = s;
    parser->addPosition(position, offset, line, path);
  }
  
  int PositionTracker::increment(UTAP::ParserBuilder *parser, int n) {
    parser->setPosition(position, position + n);
    position += n;
    offset += n;
    return position - n;
  }
  
  void PositionTracker::newline(UTAP::ParserBuilder *parser, int n) {
    line += n;
    parser->addPosition(position, offset, line, path);
  }
}

#define YY_USER_ACTION yylloc.start = PositionTracker::position; PositionTracker::increment(ch, utap_leng); yylloc.end = PositionTracker::position;

#define YY_FATAL_ERROR(msg) { throw TypeException(msg); }


#line 590 "lexer.cc"

#define INITIAL 0
#define comment 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int utap_wrap (void );
#else
extern int utap_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( utap_text, utap_leng, 1, utap_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( utap_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( utap_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, utap_in))==0 && ferror(utap_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(utap_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int utap_lex (void);

#define YY_DECL int utap_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after utap_text and utap_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 80 "lexer.ll"


#line 745 "lexer.cc"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! utap_in )
			utap_in = stdin;

		if ( ! utap_out )
			utap_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			utap_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				utap__create_buffer(utap_in,YY_BUF_SIZE );
		}

		utap__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of utap_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 102 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 101 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 83 "lexer.ll"
{ PositionTracker::newline(ch, 1); }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 84 "lexer.ll"
{ BEGIN(INITIAL); }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 85 "lexer.ll"
/* Single line comments take precedence over multilines */;
	YY_BREAK
case YY_STATE_EOF(comment):
#line 86 "lexer.ll"
{ BEGIN(INITIAL); yyerror("Unclosed comment."); return 0; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 87 "lexer.ll"
/* ignore (multiline comments)*/
	YY_BREAK

case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 90 "lexer.ll"
{ /* Use \ as continuation character */ 
                  PositionTracker::newline(ch, 1); 
                } 
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 94 "lexer.ll"
/* ignore (singleline comment)*/;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 96 "lexer.ll"

	YY_BREAK
case 8:
YY_RULE_SETUP
#line 98 "lexer.ll"
{ BEGIN(comment); }
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 100 "lexer.ll"
{
                  PositionTracker::newline(ch, utap_leng);
        	  if ((syntax & SYNTAX_PROPERTY) != 0)
        	    return '\n';
                }
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 106 "lexer.ll"
{
                  PositionTracker::newline(ch, utap_leng / 2);
        	  if ((syntax & SYNTAX_PROPERTY) != 0)
        	    return '\n';
                }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 112 "lexer.ll"
{ return '.'; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 113 "lexer.ll"
{ return ','; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 114 "lexer.ll"
{ return ';'; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 115 "lexer.ll"
{ return ':'; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 116 "lexer.ll"
{ return '{'; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 117 "lexer.ll"
{ return '}'; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 118 "lexer.ll"
{ return '['; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 119 "lexer.ll"
{ return ']'; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 120 "lexer.ll"
{ return '('; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 121 "lexer.ll"
{ return ')'; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 122 "lexer.ll"
{ return '?'; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 123 "lexer.ll"
{ return '\''; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 124 "lexer.ll"
{ return T_EXCLAM; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 126 "lexer.ll"
{ return T_ARROW; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 127 "lexer.ll"
{ return T_UNCONTROL_ARROW; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 129 "lexer.ll"
{ return T_ASSIGNMENT; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 130 "lexer.ll"
{ return T_ASSIGNMENT; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 131 "lexer.ll"
{ return T_ASSPLUS; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 132 "lexer.ll"
{ return T_ASSMINUS; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 133 "lexer.ll"
{ return T_ASSMULT; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 134 "lexer.ll"
{ return T_ASSDIV; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 135 "lexer.ll"
{ return T_ASSMOD; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 136 "lexer.ll"
{ return T_ASSOR; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 137 "lexer.ll"
{ return T_ASSAND; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 138 "lexer.ll"
{ return T_ASSXOR; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 139 "lexer.ll"
{ return T_ASSLSHIFT; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 140 "lexer.ll"
{ return T_ASSRSHIFT; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 141 "lexer.ll"
{ return T_MIN; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 142 "lexer.ll"
{ return T_MAX; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 144 "lexer.ll"
{ return T_PLUS; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 145 "lexer.ll"
{ return T_MINUS; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 146 "lexer.ll"
{ return T_MULT; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 147 "lexer.ll"
{ return T_DIV; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 148 "lexer.ll"
{ return T_MOD; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 149 "lexer.ll"
{ return T_OR; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 150 "lexer.ll"
{ return '&'; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 151 "lexer.ll"
{ return T_XOR; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 152 "lexer.ll"
{ return T_LSHIFT; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 153 "lexer.ll"
{ return T_RSHIFT; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 154 "lexer.ll"
{ return T_BOOL_OR; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 155 "lexer.ll"
{ return T_BOOL_AND; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 157 "lexer.ll"
{ return T_LEQ; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 158 "lexer.ll"
{ return T_GEQ; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 159 "lexer.ll"
{ if (syntax & SYNTAX_OLD)
                  {
                      return T_LEQ;
                  }
                  utap_error("Unknown symbol");
                  return T_ERROR;
                }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 166 "lexer.ll"
{ if (syntax & SYNTAX_OLD)
                  {
                      return T_GEQ;
                  }
                  utap_error("Unknown symbol");
                  return T_ERROR;
                }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 173 "lexer.ll"
{ return T_LT; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 174 "lexer.ll"
{ return T_GT; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 175 "lexer.ll"
{ return T_EQ; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 176 "lexer.ll"
{ return T_NEQ; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 178 "lexer.ll"
{ return T_INCREMENT; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 179 "lexer.ll"
{ return T_DECREMENT; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 181 "lexer.ll"
{ return 'A'; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 182 "lexer.ll"
{ return 'U'; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 183 "lexer.ll"
{ return 'W'; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 185 "lexer.ll"
{ return T_AF; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 186 "lexer.ll"
{ return T_AF2; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 187 "lexer.ll"
{ return T_AG; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 188 "lexer.ll"
{ return T_AG2; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 189 "lexer.ll"
{ return T_EF; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 190 "lexer.ll"
{ return T_EF2; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 191 "lexer.ll"
{ return T_EG; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 192 "lexer.ll"
{ return T_EG2; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 193 "lexer.ll"
{ return T_LEADSTO; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 195 "lexer.ll"
{
/*          	if (strlen(decl_text) >= MaxIdLen ) */
/*          		declError << "Identifier too long. Only " << MaxIdLen  */
/*          			 << " characters are significant.\n"; */
        	  const Keyword *keyword
        	    = Keywords::in_word_set(utap_text, strlen(utap_text));
		  if (keyword != NULL)
		  {
		      int32_t s = keyword->syntax;
#ifndef ENABLE_TIGA
		      /* Remove all TIGA keywords if tiga is not enabled. */
		      if (s & SYNTAX_TIGA)
		      {
			  s = 0;
		      }
#endif
		      if (syntax & s)
		      {
			  if (keyword->token == T_CONST && (syntax & SYNTAX_OLD))
			  {
			      return T_OLDCONST;
			  }
			  return keyword->token;
		      } 
		  }
		  if (ch->isType(utap_text)) 
		  {
		      strncpy(utap_lval.string, utap_text, MAXLEN);
		      utap_lval.string[MAXLEN - 1] = '\0';
		      return T_TYPENAME;
                  } 
		  else 
		  {
        	      strncpy(utap_lval.string, utap_text, MAXLEN);
        	      utap_lval.string[MAXLEN - 1] = '\0';
		      return T_ID;
        	  }
                }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 234 "lexer.ll"
{ 
                  utap_lval.number = atoi(utap_text); 
                  return T_NAT; 
                }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 239 "lexer.ll"
{ 
        	  utap_error("Unknown symbol");
                  return T_ERROR; 
                }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 244 "lexer.ll"
{ return 0; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 246 "lexer.ll"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1287 "lexer.cc"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed utap_in at a new source and called
			 * utap_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = utap_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( utap_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * utap_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of utap_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					utap_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			utap_restart(utap_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 102 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 102 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 101);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					utap_restart(utap_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( utap_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve utap_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void utap_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        utap_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            utap__create_buffer(utap_in,YY_BUF_SIZE );
	}

	utap__init_buffer(YY_CURRENT_BUFFER,input_file );
	utap__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void utap__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		utap_pop_buffer_state();
	 *		utap_push_buffer_state(new_buffer);
     */
	utap_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	utap__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (utap_wrap()) processing, but the only time this flag
	 * is looked at is after utap_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void utap__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	utap_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE utap__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) utap_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in utap__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) utap_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in utap__create_buffer()" );

	b->yy_is_our_buffer = 1;

	utap__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with utap__create_buffer()
 * 
 */
    void utap__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		utap_free((void *) b->yy_ch_buf  );

	utap_free((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a utap_restart() or at EOF.
 */
    static void utap__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	utap__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then utap__init_buffer was _probably_
     * called from utap_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void utap__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		utap__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void utap_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	utap_ensure_buffer_stack();

	/* This block is copied from utap__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from utap__switch_to_buffer. */
	utap__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void utap_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	utap__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		utap__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void utap_ensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)utap_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)utap_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE utap__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) utap_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in utap__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	utap__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to utap_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       utap__scan_bytes() instead.
 */
YY_BUFFER_STATE utap__scan_string (yyconst char * yystr )
{
    
	return utap__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to utap_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE utap__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) utap_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in utap__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = utap__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in utap__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up utap_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		utap_text[utap_leng] = (yy_hold_char); \
		(yy_c_buf_p) = utap_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		utap_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int utap_get_lineno  (void)
{
        
    return utap_lineno;
}

/** Get the input stream.
 * 
 */
FILE *utap_get_in  (void)
{
        return utap_in;
}

/** Get the output stream.
 * 
 */
FILE *utap_get_out  (void)
{
        return utap_out;
}

/** Get the length of the current token.
 * 
 */
int utap_get_leng  (void)
{
        return utap_leng;
}

/** Get the current token.
 * 
 */

char *utap_get_text  (void)
{
        return utap_text;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void utap_set_lineno (int  line_number )
{
    
    utap_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see utap__switch_to_buffer
 */
void utap_set_in (FILE *  in_str )
{
        utap_in = in_str ;
}

void utap_set_out (FILE *  out_str )
{
        utap_out = out_str ;
}

int utap_get_debug  (void)
{
        return utap__flex_debug;
}

void utap_set_debug (int  bdebug )
{
        utap__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from utap_lex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    utap_in = stdin;
    utap_out = stdout;
#else
    utap_in = (FILE *) 0;
    utap_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * utap_lex_init()
     */
    return 0;
}

/* utap_lex_destroy is for both reentrant and non-reentrant scanners. */
int utap_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		utap__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		utap_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	utap_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * utap_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *utap_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *utap_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void utap_free (void * ptr )
{
	free( (char *) ptr );	/* see utap_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 246 "lexer.ll"



int utap_wrap() {
  return 1;
}



