/*
 * training_set.h
 *
 *  Created on: Nov 16, 2015
 *      Author: cedric
 */

#ifndef TRAINING_SET_H
#define TRAINING_SET_H

#include "../task_proxy.h"

#include <utility>
#include <vector>

class TrainingSet{
public:
	TrainingSet();
	~TrainingSet() = default;
	void add_entry(const std::pair<State, int> &entry);
	void add_entry(const State &state, int heuristic_value);
	size_t size();
	std::pair<State, int> operator[](int index);
	void replace_value(int index, int value);
	void clear();

private:
	std::vector<std::pair<State, int> > learning_set;

	bool contains_state(const State &state);
};





#endif /* SRC_SEARCH_BOOTSTRAP_TRAINING_SET_H_ */
