/*
 * training_set.cc
 *
 *  Created on: Nov 16, 2015
 *      Author: cedric
 */

#include "training_set.h"
#include "helper.h"

using namespace std;

TrainingSet::TrainingSet(){

}

void TrainingSet::add_entry(const pair<State, int> &entry){
	add_entry(entry.first, entry.second);
}

void TrainingSet::add_entry(const State &state, int heuristic_value){
	if(!contains_state(state)){
		learning_set.push_back(make_pair(state, heuristic_value));
	}
}


bool TrainingSet::contains_state(const State &state){
	bool no_break = false;
	for(auto p : learning_set){
		no_break = true;
		for(size_t i = 0; i < p.first.size(); i++){
			if(p.first[i].get_value() != state[i].get_value()){
				no_break = false;
				break;
			}
		}
		if(no_break){
			//Helper::print_same_state(p.first, state);
			return true;
		}
	}
	return false;
}

void TrainingSet::clear(){
	learning_set.clear();
}

size_t TrainingSet::size(){
	return learning_set.size();
}

pair<State, int> TrainingSet::operator[](int index){
	return learning_set[index];
}

void TrainingSet::replace_value(int index, int value){
	learning_set[index].second = value;
}
