/*
 * heuritic_wrapper.cc
 *
 *  Created on: Dec 18, 2015
 *      Author: cedric
 */

#include "heuristic_wrapper.h"

#include "feature_extractor/feature_extractor.h"

#include "../state_registry.h"

#include <iostream>
#include <vector>

using namespace std;

HeuristicWrapper::HeuristicWrapper(string heuristic_function_name){
	set_heuristic_function(heuristic_function_name);
}

void HeuristicWrapper::set_heuristic_function(string heuristic_function_name){
	OptionParser parser(heuristic_function_name, false);
	heuristic = parser.start_parsing<Heuristic *>();
}

int HeuristicWrapper::get_heuristic_value(const State &state){
	vector<int> initial_state_data = g_initial_state_data;
	g_initial_state_data = FeatureExtractor::extract_features(state);
	delete g_state_registry;
	g_state_registry = new StateRegistry;
	const GlobalState g = g_state_registry->get_initial_state();
	int h = get_heuristic_value(g);
	g_initial_state_data = initial_state_data;
	delete g_state_registry;
	g_state_registry = new StateRegistry;
	return h;
}


int HeuristicWrapper::get_heuristic_value(const GlobalState &g_state){
	EvaluationContext eval_context(g_state);
	int h = eval_context.get_heuristic_value_or_infinity(heuristic);
	return h;
}
