#include "feature_extractor.h"

#include "../../task_proxy.h"

using namespace std;

int FeatureExtractor::get_num_features(const State &state){
	return state.size();
}

void FeatureExtractor::extract_features(const State &state, vector<int> &features){
	features.clear();
	for(size_t i = 0; i < state.size(); i++){
		features.push_back(state[i].get_value());
	}
}

vector<int> FeatureExtractor::extract_features(const State &state){
	vector<int> features;
	FeatureExtractor::extract_features(state, features);
	return features;
}
