#ifndef NEURON_H
#define NEURON_H

#include <vector>

class Neuron;

typedef std::vector<Neuron *> Layer;

class Neuron{
public:
	Neuron(int number_of_outputs, int index);
	virtual ~Neuron() = default;
	void set_output_value(double value);
	double get_output_value(void) const;
	void feed_forward(const Layer &previous_layer);
	void calculate_output_gradients(double expected_value);
	void calculate_hidden_gradients(const Layer &next_layer);
	virtual double transfer_function(double in);
	virtual double transfer_function_derivative(double in);void update_input_weights(Layer &previous_layer);

	static double eta;
	static double alpha;
protected:
	double output_value = 0.0;
	double gradient = 0.0;
	int index;
	std::vector<double> output_weights;
	std::vector<double> delta_weights;

};

#endif
