#! /usr/bin/env python

"""
Example downward experiment that runs FF on two tasks.

Please adapt EXPPATH and REPO to be the path where the experiment shall be put
and the location of your Fast Downward repository.

The file planner.py contains the "basic" version of this experiment.
"""

import os
import platform

from downward.checkouts import Translator, Preprocessor, Planner
from downward.experiment import DownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport
from lab.steps import Step
from downward import suites
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment


exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)
REPO = os.path.expanduser('~/workspace/masterthesis/project')
NODE = platform.node()
REMOTE = 'cluster' in NODE

if REMOTE:
  environment = MaiaEnvironment(priority=-1,
                                email='cedric.geissmann@unibas.ch')
else:
  environment = LocalEnvironment(processes=2)

# Use CMake and Make revision.
TRANSLATE_REV = '209da9c81a7a'
# Adapt
REVS = ['008b9a8762bb']
COMBOS = [
    (Translator(REPO, rev=TRANSLATE_REV), Preprocessor(REPO, rev=TRANSLATE_REV), Planner(REPO, rev=rev))
    for rev in REVS
]

exp = DownwardExperiment(
    EXPPATH, REPO, environment=environment, combinations=COMBOS, limits={'search_memory': 2048, 'search_time': 1800})

exp.set_path_to_python(os.path.expanduser('~/local/bin/python2.7'))

DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]

if REMOTE:
  exp.add_suite(suites.suite_satisficing_with_ipc11())
#  exp.add_suite([
#    'gripper:prob01.pddl',
#    'gripper:prob02.pddl',
#    'depot:pfile1',
#    'depot:pfile2',
#    ])
else:
  exp.add_suite([
    'gripper:prob01.pddl',
    'gripper:prob01.pddl',
    'assembly:prob02.pddl',
    'assembly:prob02.pddl',
    'depot:pfile1',
    'depot:pfile2',
    ])

# Adapt
#exp.add_config('blind', ['--search', 'astar(blind)'])
#exp.add_config('lmcut', ['--search', 'astar(lmcut)'])
exp.add_config('ff', ['--search', 'astar(ff)'])
#exp.add_config('add', ['--search', 'astar(add)'])
exp.add_config('pdb', ['--search', 'astar(pdb)'])
exp.add_config('bootstrap-none', ['--search', 'astar(bootstrap(t_max=40, ins_min=200, initial_heuristic=none, number_of_rw=500, rw_length=50, ann_topology=50, eta=0.0002, epochs=500))'])
exp.add_config('bootstrap-blind', ['--search', 'astar(bootstrap(t_max=40, ins_min=200, initial_heuristic=blind, number_of_rw=500, rw_length=50, ann_topology=50, eta=0.0002, epochs=500))'])
exp.add_config('bootstrap-ff', ['--search', 'astar(bootstrap(t_max=40, ins_min=200, initial_heuristic=ff, number_of_rw=500, rw_length=50, ann_topology=50, eta=0.0002, epochs=500))'])
exp.add_report(AbsoluteReport(resolution='combined', attributes=DEFAULT_ATTRIBUTES), name='make-report', outfile='report-abs-p.html')

exp()
