#! /usr/bin/env python

from lab.experiment import Experiment 
from downward.experiment import DownwardExperiment 
from lab.reports import Attribute, avg
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment
from downward.checkouts import Translator, Preprocessor, Planner
from downward.reports.absolute import AbsoluteReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport


import os
import platform

exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)

def rename_configs(run):
#    config = re.sub(r"^\w+-\w+-\w+-", '', run['config'])
    run['config'] = run['commandline_config'][1]
    return run


DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]

training_set_size = Attribute('training_set_size', absolute=False, min_wins=True, functions=[avg])

attributes=list(DEFAULT_ATTRIBUTES)
attributes.append(training_set_size)


exp = Experiment(EXPPATH)

exp.add_fetcher('data/experiment_search_topology', parsers=['learning-parser.py'])
exp.add_fetcher('data/experiment_search_basic', parsers=['learning-parser.py'], name='search_basic')

FILTER_CONFIGS = [
	'209da9c81a7a-209da9c81a7a-168c2b5da02b-blind',
	'85a613151f58-85a613151f58-c4916925c01e-bootstrap-search',
	'209da9c81a7a-209da9c81a7a-168c2b5da02b-ff',
]

exp.add_report(AbsoluteReport(resolution='combined', attributes=attributes, filter=rename_configs), name='make-report', outfile='report-abs-p.html')

exp()
