#! /usr/bin/env python

"""
Example downward experiment that runs FF on two tasks.

Please adapt EXPPATH and REPO to be the path where the experiment shall be put
and the location of your Fast Downward repository.

The file planner.py contains the "basic" version of this experiment.
"""

import os
import platform

from downward.checkouts import Translator, Preprocessor, Planner
from downward.experiment import DownwardExperiment
from lab.reports import Attribute, avg
from downward.reports.absolute import AbsoluteReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport
from lab.steps import Step
from downward import suites
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment


exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)
REPO = os.path.expanduser('~/workspace/masterthesis/project')
NODE = platform.node()
REMOTE = 'cluster' in NODE

if REMOTE:
  environment = MaiaEnvironment(priority=-2,
                                email='cedric.geissmann@unibas.ch')
else:
  environment = LocalEnvironment(processes=2)

# Use CMake and Make revision.
TRANSLATE_REV = '209da9c81a7a'
# Adapt
REVS = ['168c2b5da02b']
COMBOS = [
    (Translator(REPO, rev=TRANSLATE_REV), Preprocessor(REPO, rev=TRANSLATE_REV), Planner(REPO, rev=rev))
    for rev in REVS
]

exp = DownwardExperiment(
    EXPPATH, REPO, environment=environment, combinations=COMBOS, limits={'search_memory': 2048, 'search_time': 1800})

exp.set_path_to_python(os.path.expanduser('~/local/bin/python2.7'))

DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]

training_set_size = Attribute('training_set_size', absolute=False, min_wins=True, functions=[avg])

attributes=list(DEFAULT_ATTRIBUTES)
attributes.append(training_set_size)

if REMOTE:
#  exp.add_suite(suites.suite_satisficing_with_ipc11())
  exp.add_suite([
    'airport',
    'airport-adl',
    'barman-opt11-strips',
    'barman-sat11-strips',
    'blocks',
    'depot',
    'driverlog',
    'elevators-opt08-strips',
    'elevators-opt11-strips',
    'elevators-sat08-strips',
    'elevators-sat11-strips',
    'floortile-opt11-strips',
    'floortile-sat11-strips',
    'freecell',
    'grid',
    'gripper',
    'logistics00',
    'logistics98',
    'miconic',
    'miconic-simpleadl',
    'movie',
    'mprime',
    'mystery',
    'no-mprime',
    'no-mystery',
    'nomystery-opt11-strips',
    'nomystery-sat11-strips',
    'openstacks-opt08-strips',
    'openstacks-opt11-strips',
    'openstacks-sat08-adl',
    'openstacks-sat08-strips',
    'openstacks-sat11-strips',
    'openstacks-strips',
    'parcprinter-08-strips',
    'parcprinter-opt11-strips',
    'parcprinter-sat11-strips',
    'parking-opt11-strips',
    'parking-sat11-strips',
    'pathways',
    'pathways-noneg',
    'pegsol-08-strips',
    'pegsol-opt11-strips',
    'pegsol-sat11-strips',
    'pipesworld-notankage',
    'pipesworld-tankage',
    'psr-small',
    'rovers',
    'satellite',
    'scanalyzer-08-strips',
    'scanalyzer-opt11-strips',
    'scanalyzer-sat11-strips',
    'schedule',
    'sokoban-opt08-strips',
    'sokoban-opt11-strips',
    'sokoban-sat08-strips',
    'sokoban-sat11-strips',
    'storage',
    'tidybot-opt11-strips',
    'tidybot-sat11-strips',
    'tpp',
    'transport-opt08-strips',
    'transport-opt11-strips',
    'transport-sat08-strips',
    'transport-sat11-strips',
    'trucks-strips',
    'visitall-opt11-strips',
    'visitall-sat11-strips',
    'woodworking-opt08-strips',
    'woodworking-opt11-strips',
    'woodworking-sat08-strips',
    'woodworking-sat11-strips',
    'zenotravel'
  ])
else:
  exp.add_suite([
 #   'gripper',
    'gripper:prob01.pddl',
    'gripper:prob02.pddl',
    'depot:pfile1',
    'depot:pfile2',
    ])

depth = 50
num = 200
topo = '50'
etaxs = 0.002

# Adapt
#exp.add_config('lmcut', ['--search', 'astar(lmcut)'])
exp.add_config('ipdb', ['--search', 'astar(ipdb)'])

exp.add_report(AbsoluteReport(resolution='combined', attributes=attributes), name='make-report', outfile='report-abs-p.html')

exp.add_search_parser('learning-parser.py')

exp()
