#! /usr/bin/env python

"""
Example downward experiment that runs FF on two tasks.

Please adapt EXPPATH and REPO to be the path where the experiment shall be put
and the location of your Fast Downward repository.

The file planner.py contains the "basic" version of this experiment.
"""

import os
import platform

from downward.checkouts import Translator, Preprocessor, Planner
from lab.experiment import Experiment
from downward.experiment import DownwardExperiment
from lab.reports import Attribute, avg
from downward.reports.absolute import AbsoluteReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport
from lab.steps import Step
from downward import suites
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment


exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)
REPO = os.path.expanduser('~/workspace/masterthesis/project')
NODE = platform.node()
REMOTE = 'cluster' in NODE


exp = Experiment(EXPPATH)

exp.add_fetcher('data/experiment_search_basic', parsers=['learning-parser.py'], filter_config=['85a613151f58-85a613151f58-c4916925c01e-bootstrap-search'], name='search_basic')
exp.add_fetcher('data/experiment_biss', parsers=['learning-parser.py'], name='biss')


DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]


FILTER_CONFIGS = [
	'85a613151f58-85a613151f58-c4916925c01e-bootstrap-search',
	'85a613151f58-85a613151f58-9a900da49d99-bootstrap-biss'
]

training_set_size = Attribute('training_set_size', absolute=False, min_wins=True, functions=[avg])

attributes=list(DEFAULT_ATTRIBUTES)
attributes.append(training_set_size)


exp.add_report(AbsoluteReport(resolution='combined', attributes=attributes, filter_domain=['psr-small']), name='make-report', outfile='report-abs-p.html')
exp.add_report(AbsoluteReport(resolution='combined', attributes=attributes, filter_domain=['psr-small'], format='tex'), name='make-report-tex', outfile='report-abs-p.tex')

exp.add_report(ScatterPlotReport(attributes=['expansions'], filter_domain=['psr-small'], format='png'), name='scatter', outfile='scatter.png')
exp()
