#! /usr/bin/env python

from lab.experiment import Experiment 
from downward.experiment import DownwardExperiment 
from lab.reports import Attribute, avg
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment
from downward.checkouts import Translator, Preprocessor, Planner
from downward.reports.absolute import AbsoluteReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport


import os
import platform

exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)

DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]

training_set_size = Attribute('training_set_size', absolute=False, min_wins=True, functions=[avg])

attributes=list(DEFAULT_ATTRIBUTES)
attributes.append(training_set_size)


exp = Experiment(EXPPATH)

exp.add_fetcher('data/experiment_basic_config/', parsers=['learning-parser.py'], name='walk')
exp.add_fetcher('data/experiment_search_basic', parsers=['learning-parser.py'], name='search_basic')

FILTER_CONFIGS = [
	'85a613151f58-85a613151f58-c4916925c01e-bootstrap-search',
	'209da9c81a7a-209da9c81a7a-168c2b5da02b-bootstrap-walk'
]


FILTER_DOMAINS = [
    'airport',
#    'airport-adl',
    'barman-opt11-strips',
    'barman-sat11-strips',
    'blocks',
    'depot',
    'driverlog',
    'elevators-opt08-strips',
    'elevators-opt11-strips',
    'elevators-sat08-strips',
    'elevators-sat11-strips',
    'floortile-opt11-strips',
    'floortile-sat11-strips',
    'freecell',
    'grid',
    'gripper',
    'logistics00',
    'logistics98',
    'miconic',
#    'miconic-simpleadl',
    'movie',
    'mprime',
    'mystery',
    'no-mprime',
    'no-mystery',
    'nomystery-opt11-strips',
    'nomystery-sat11-strips',
    'openstacks-opt08-strips',
    'openstacks-opt11-strips',
#    'openstacks-sat08-adl',
    'openstacks-sat08-strips',
    'openstacks-sat11-strips',
    'openstacks-strips',
    'parcprinter-08-strips',
    'parcprinter-opt11-strips',
    'parcprinter-sat11-strips',
    'parking-opt11-strips',
    'parking-sat11-strips',
    'pathways',
    'pathways-noneg',
    'pegsol-08-strips',
    'pegsol-opt11-strips',
    'pegsol-sat11-strips',
    'pipesworld-notankage',
    'pipesworld-tankage',
    'psr-small',
    'rovers',
    'satellite',
    'scanalyzer-08-strips',
    'scanalyzer-opt11-strips',
    'scanalyzer-sat11-strips',
    'schedule',
    'sokoban-opt08-strips',
    'sokoban-opt11-strips',
    'sokoban-sat08-strips',
    'sokoban-sat11-strips',
    'storage',
    'tidybot-opt11-strips',
    'tidybot-sat11-strips',
    'tpp',
    'transport-opt08-strips',
    'transport-opt11-strips',
    'transport-sat08-strips',
    'transport-sat11-strips',
    'trucks-strips',
    'visitall-opt11-strips',
    'visitall-sat11-strips',
    'woodworking-opt08-strips',
    'woodworking-opt11-strips',
    'woodworking-sat08-strips',
    'woodworking-sat11-strips',
    'zenotravel'
]

exp.add_report(AbsoluteReport(resolution='combined', attributes=attributes, filter_config=FILTER_CONFIGS, filter_domain=FILTER_DOMAINS), name='make-report', outfile='report-abs-p.html')
exp.add_report(AbsoluteReport(resolution='combined', attributes=attributes, filter_config=FILTER_CONFIGS, filter_domain=FILTER_DOMAINS, format='tex'), name='make-report-tex', outfile='experiment-walk.tex')

exp()
