#! /usr/bin/env python

from downward.experiment import DownwardExperiment
from lab.reports import Attribute, avg
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment
from downward.checkouts import Translator, Preprocessor, Planner
from downward.reports import Report
from downward.reports.taskwise import TaskwiseReport
from downward.reports.absolute import AbsoluteReport
from downward.reports.compare import CompareConfigsReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport

import re
import os
import platform

def rename_configs(run):
    config = re.sub(r"^\w+-\w+-\w+-", '', run['config'])
    run['config'] = config
    return run

exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)

DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]

training_set_size = Attribute('training_set_size', absolute=False, min_wins=True, functions=[avg])

attributes=list(DEFAULT_ATTRIBUTES)
attributes.append(training_set_size)


FILTER_CONFIG = ['bootstrap-blind-500-50-50', 
	#'209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-blind-500-50-50',
	'ff',
	'blind'
]

#exp.add_report(Report(filter_coverage=1, attributes=attributes, format='tex'), name='make-report', outfile='report-abs-p.tex')

COMPARED_CONFIGS = [
	('blind', 'bootstrap-blind-200-50-50', 'Diff(bootstrap-ff)'),
	#('209da9c81a7a-209da9c81a7a-e4e7e3b89329-blind', '209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-blind-200-50-50', 'Diff(bootstrap-ff)'),
	#('209da9c81a7a-209da9c81a7a-008b9a8762bb-ff', '209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-ff-200-50-50', 'Diff(bootstrap-ff)'),
	#('209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-none-200-50-50', '209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-ff-200-50-50', 'Diff(bootstrap-ff)')
]

#exp.add_report(CompareConfigsReport(compared_configs=COMPARED_CONFIGS, attributes=attributes, format='tex'), name='make-report', outfile='report-compare-p.tex')

report = AbsoluteReport(attributes=attributes, resolution='combined', format='tex', filter=rename_configs, filter_coverage=1)
report('data/experiment_basic_config-eval', 'myreport.tex')
