#! /usr/bin/env python

from downward.experiment import DownwardExperiment
from lab.reports import Attribute, avg
from lab.environments import MaiaEnvironment
from lab.environments import LocalEnvironment
from downward.checkouts import Translator, Preprocessor, Planner
from downward.reports.absolute import AbsoluteReport
from downward.reports.compare import CompareConfigsReport
from downward.reports.suite import SuiteReport
from downward.reports.scatter import ScatterPlotReport


import os
import platform

exp_name = os.path.splitext(os.path.basename(os.path.abspath(__file__)))[0]
EXPPATH = os.path.join(os.path.expanduser('~/workspace/masterthesis/project/experiments/learning/data'), exp_name)
REPO = os.path.expanduser('~/workspace/masterthesis/project')
NODE = platform.node()
REMOTE = 'cluster' in NODE

if REMOTE:
  environment = MaiaEnvironment(priority=-1,
                                email='cedric.geissmann@unibas.ch')
else:
  environment = LocalEnvironment(processes=2)

# Use CMake and Make revision.
TRANSLATE_REV = '209da9c81a7a'
# Adapt
REVS = ['008b9a8762bb']
COMBOS = [
    (Translator(REPO, rev=TRANSLATE_REV), Preprocessor(REPO, rev=TRANSLATE_REV), Planner(REPO, rev=rev))
    for rev in REVS
]

DEFAULT_ATTRIBUTES = [
    'cost',
    'coverage',
    'error',
    'evaluations_until_last_jump',
    'expansions_until_last_jump',
    'generated_until_last_jump',
    'initial_h_value',
    'memory',
    'run_dir',
    #'search_returncode',
    'search_time',
    'total_time',
    'evaluations',
    'expansions',
    'generated',
]

training_set_size = Attribute('training_set_size', absolute=False, min_wins=True, functions=[avg])

attributes=list(DEFAULT_ATTRIBUTES)
attributes.append(training_set_size)


exp = DownwardExperiment(
    EXPPATH, REPO, environment=environment, combinations=COMBOS, limits={'search_memory': 2048, 'search_time': 1800})

FILTER_CONFIG = ['bootstrap-blind-500-50-50', 'ff']

exp.add_fetcher('data/collected-data-eval', filter_coverage=1)
exp.add_fetcher('data/test_samples-eval', filter_coverage=1)
exp.add_fetcher('data/test_topo-eval', filter_coverage=1)


exp.add_report(AbsoluteReport(filter_coverage=1, resolution='combined', attributes=attributes), name='make-report', outfile='report-abs-p.html')

COMPARED_CONFIGS = [
	#('209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-none-200-50-50', '209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-ff-200-50-50', 'Diff(bootstrap-ff)'),
	('209da9c81a7a-209da9c81a7a-008b9a8762bb-ff', '209da9c81a7a-209da9c81a7a-e4e7e3b89329-bootstrap-ff-200-50-50', 'Diff(bootstrap-ff)')
]

exp.add_report(CompareConfigsReport(compared_configs=COMPARED_CONFIGS, attributes=attributes), name='make-report', outfile='report-compare-p.html')

exp()
