(define (domain psr)
  (:requirements :adl :derived-predicates)
  (:types DEVICE SIDE LINE)
  (:constants side1 side2 - SIDE earth - DEVICE)
  (:predicates (ext ?l - LINE ?x - DEVICE ?s - SIDE)
               (breaker ?x - DEVICE)
               (closed ?x - DEVICE)
               (faulty ?l - LINE)
               (con ?x - DEVICE ?sx - SIDE ?y - DEVICE ?sy - SIDE)

               (upstream ?x - DEVICE ?sx - SIDE ?y - DEVICE ?sy - SIDE)
               (unsafe ?x - DEVICE ?sx - SIDE)
               (affected ?x - DEVICE)
	       (fed ?l - LINE))

  (:derived (upstream ?x - DEVICE ?sx - SIDE ?y - DEVICE ?sy - SIDE)
      (and (closed ?x)
           (or (and (= ?sx side1) (con ?x side2 ?y ?sy))
               (and (= ?sx side2) (con ?x side1 ?y ?sy))
               (exists (?z - DEVICE)
		  (and (closed ?z)
                       (or (and (con ?z side1 ?y ?sy)
                                (upstream ?x ?sx ?z side2))
                           (and (con ?z side2 ?y ?sy)
                                (upstream ?x ?sx ?z side1))))))))


  (:derived (unsafe ?x - DEVICE ?sx - SIDE)
     (and (closed ?x)
          (or (and (= ?sx side1)
                   (exists (?l - LINE)
                      (and (ext ?l ?x side2)
                           (or (faulty ?l)
                               (exists (?y - DEVICE)
                                  (exists (?sy - SIDE)
                                     (and (con ?x side2 ?y ?sy)
                                          (unsafe ?y ?sy))))))))
              (and (= ?sx side2)
                   (exists (?l - LINE)
                      (and (ext ?l ?x side1)
                           (or (faulty ?l)
                               (exists (?y - DEVICE)
                                  (exists (?sy - SIDE)
                                     (and (con ?x side1 ?y ?sy)
                                          (unsafe ?y ?sy)))))))))))

  (:derived (affected ?x - DEVICE)
        (and (breaker ?x)
             (exists (?sx - SIDE) (unsafe ?x ?sx))))

  (:derived (fed ?l - LINE)
      (exists (?x - DEVICE) 
              (and (closed ?x) 
                   (or (and (ext ?l ?x side1) 
                            (or (breaker ?x)
                                (exists (?y - DEVICE)
                                   (exists (?sy - SIDE)
                                      (and (breaker ?y)
                                           (upstream ?y ?sy ?x side2))))))
                       (and (ext ?l ?x side2) 
                            (or (breaker ?x)
                                (exists (?y - DEVICE)
                                   (exists (?sy - SIDE)
                                      (and (breaker ?y)
                                           (upstream ?y ?sy ?x side1))))))))))

  (:action open
    :parameters (?x - DEVICE)
    :precondition (and (not (= ?x earth))
		       (closed ?x) 
                       (forall (?b - DEVICE) (not (affected ?b))))
    :effect (not (closed ?x)))

  (:action close
    :parameters  (?x - DEVICE)
    :precondition (and (not (= ?x earth))
		       (not (closed ?x))
                       (forall (?b - DEVICE) (not (affected ?b))))
    :effect (closed ?x))

  (:action wait
    :parameters  ()
    :precondition (exists (?b - DEVICE) (affected ?b))
    :effect (forall (?b - DEVICE) (when (affected ?b) (not (closed ?b)))))

)
