#include "lin_alg.h"

//#include <iostream>
#include <vector>
#include <limits>

//#define max(a,b) ((a)>(b)?(a):(b))
//#define min(a,b) ((a)<(b)?(a):(b))
using namespace std;

namespace utils{

vector<double> solve_gauss(vector<vector<double>> a, vector<double> b){
    size_t size = a.size();
    vector<double> result;
    result.resize(size);
    vector<double> temp;
    temp.resize(size);
    vector<vector<double>> l;
    l.resize(size);
    for (size_t row=0; row<l.size(); ++row){
        l[row].resize(row+1);
    }
    for (size_t i=0; i<size; ++i){
        l[i][i]=1.;
    }
    for (size_t k=0; k<size-1; k++){
        for(size_t i=k+1; i<size; i++){
            l[i][k] = ((double)a[i][k])/a[k][k];
            for(size_t j=k; j<size; ++j){
                a[i][j]-=l[i][k]*a[k][j];
            }
        }
    }
    for (size_t i=1; i<size; ++i){
        for(size_t j=0; j<i; ++j){
            b[i]-=a[i][j]*b[j];
        }
    }
    result[size-1]=b[size-1]/a[size-1][size-1];
    for (int i=size-2; i>=0; --i){
        for (size_t j=i+1; j<size; ++j){
            b[i]-=a[i][j]*result[j];
        }
        result[i]=b[i]/a[i][i];
    }
    return result;
}
vector<double> solve_gauss(vector<vector<double>> a, double* b){
    size_t size = a.size();
    vector<double> result;
    result.resize(size);
    vector<double> temp;
    temp.resize(size);
    vector<vector<double>> l;
    l.resize(size);
    for (size_t row=0; row<l.size(); ++row){
        l[row].resize(row+1);
    }
    for (size_t i=0; i<size; ++i){
        l[i][i]=1.;
    }
    for (size_t k=0; k<size-1; k++){
        for(size_t i=k+1; i<size; i++){
            /*note: does NOT check whether pivot is 0!
                (ok, for pot.calc. algebraic)*/
            l[i][k] = a[i][k]/a[k][k];
            for(size_t j=k; j<size; ++j){
                a[i][j]-=l[i][k]*a[k][j];
            }
        }
    }
    for (size_t i=1; i<size; ++i){
        for(size_t j=0; j<i; ++j){
            b[i]-=a[i][j]*b[j];
        }
    }
    result[size-1]=b[size-1]/a[size-1][size-1];
    for (int i=size-2; i>=0; --i){
        for (size_t j=i+1; j<size; ++j){
            b[i]-=a[i][j]*result[j];
        }
        result[i]=b[i]/a[i][i];
    }
    return result;
}
vector<double> mod_gauss(vector<vector<double>> a, vector<double> b){
    size_t size = a.size();
    vector<double> result;
    result.resize(size);
    vector<double> temp;
    temp.resize(size);
    vector<vector<double>> l;
    l.resize(size);
    for (size_t row=0; row<l.size(); ++row){
        l[row].resize(row+1);
    }
    for (size_t i=0; i<size; ++i){
        l[i][i]=1.;
    }
    double eps = 1./numeric_limits<int>::max();
    for (size_t k=0; k<size-1; k++){
        if(a[k][k]*a[k][k]<eps)a[k][k]=1.;
        /*note: doesn't check whether whole line is 0!
            (ok for pot.calc. total)*/
        for(size_t i=k+1; i<size; i++){
            l[i][k] = a[i][k]/a[k][k];
            for(size_t j=k; j<size; ++j){
                a[i][j]-=l[i][k]*a[k][j];
            }
        }
    }
    for (size_t i=1; i<size; ++i){
        for(size_t j=0; j<i; ++j){
            b[i]-=a[i][j]*b[j];
        }
    }
    result[size-1]=b[size-1]/a[size-1][size-1];
    for (int i=size-2; i>=0; --i){
        for (size_t j=i+1; j<size; ++j){
            b[i]-=a[i][j]*result[j];
        }
        result[i]=b[i]/a[i][i];
    }
    return result;
}
}
