#ifndef POTENTIALS_UTIL_H
#define POTENTIALS_UTIL_H

#include "../pdbs/types.h"
#include "../pdbs/pdb_h_tensor.h"

#include <string>
#include <vector>
#include <map>

class State;

class TaskProxy;
class VariablesProxy;

namespace options {
class OptionParser;
}

namespace potentials {
class PotentialOptimizer;

std::vector<State> sample_without_dead_end_detection(
    PotentialOptimizer &optimizer, int num_samples);

std::string get_admissible_potentials_reference();
void prepare_parser_for_admissible_potentials(options::OptionParser &parser);

struct IntermediateAverage{
    double sum;
    size_t num;
};

pdbs::Pattern pattern_without(const pdbs::Pattern &oldPattern, const int &var_id);

std::vector<int> make_important_vars_list(const TaskProxy &task_proxy,
                                          const VariablesProxy &vars);

double get_average_pdbh(std::vector<int> values,
                        const std::vector<pdbs::PatternDatabase> &pdb_s,
                        const pdbs::Pattern &free_vars,
                        const std::vector<size_t> &domain_sizes);

std::vector<size_t> get_num_patterns_with_var(
    const pdbs::PatternCollection &patterns, const size_t &num_vars);

std::vector<size_t> get_pattern_indices_with_var(
    const pdbs::PatternCollection &patterns, const size_t &var_id);

std::map<std::vector<int>,double> &get_all_h(const pdbs::PatternDatabase &pdb,
    const pdbs::Pattern &pattern, const std::vector<size_t> &domain_sizes,
    std::map<std::vector<int>,double> &result, TaskProxy &task_proxy,
    std::vector<int> values=std::vector<int>());

IntermediateAverage get_avg_h(
    const pdbs::PDBhTensor &h_tensor, std::vector<int> values,
    const pdbs::Pattern free_vars, const std::vector<size_t> &domain_sizes);

double get_average_h(
    const std::vector<pdbs::PDBhTensor> &h_tensors, const size_t &var_id,
    const size_t &value, const pdbs::PatternCollection &patterns,
    const std::vector<size_t> &domain_sizes);

std::vector<pdbs::PatternDatabase> filter_patterns(
    const pdbs::PatternCollection &all_patterns,
    const size_t max_num_patterns,
    const TaskProxy &task_proxy);
}
std::vector<std::vector<double>> make_ata(std::vector<size_t> &domain_sizes);
#endif
