#ifndef POTENTIALS_POTENTIAL_CALCULATOR_GREEDY_H
#define POTENTIALS_POTENTIAL_CALCULATOR_GREEDY_H

#include "potential_calculator.h"

#include "../pdbs/types.h"
#include "../pdbs/pdb_h_tensor.h"
#include "../option_parser.h"
#include "../task_proxy.h"

#include <vector>
#include <map>

namespace potentials{

class ListElementFact{

public:
    size_t var,val;
    double delta,abs_delta;
    ListElementFact* prev;
    ListElementFact* next;

//public:
    ListElementFact(){};
    ListElementFact(const size_t& var,const size_t& val,const double& delta):
        var(var),val(val),delta(delta),prev(nullptr),next(nullptr){
        if(delta<0){abs_delta=-delta;}
        else{abs_delta=delta;}
    };
    bool bubble_up(){
        if(prev!=nullptr){return prev->abs_delta<abs_delta;}
        else{return false;}
    };
    bool bubble_down(){
        if(next!=nullptr){return next->abs_delta>abs_delta;}
        else{return false;}
    };
};

class FactList{
    ListElementFact* root;
    //ListElementFact* iterator;
    std::vector<ListElementFact*> elements;
    size_t num_vars,num_facts;
    std::vector<pdbs::Pattern> patterns;
    std::vector<size_t> domain_sizes;
    std::vector<std::vector<size_t>> influence_matrix;
    //double EPS=1e-12;

public:
    FactList():root(nullptr){};
    FactList(const std::vector<pdbs::PDBhTensor> &h_tensors,
        const std::vector<size_t> &domain_sizes,
        const std::vector<pdbs::Pattern> &patterns);
    ~FactList() = default;

    ListElementFact* operator[](const std::array<size_t,2>& var_val);

    void bubblesort(ListElementFact* to_sort);
    //void bubblesort(const std::vector<ListElementFact*> &to_sort);
    //void bubblesort(const std::vector<size_t> &to_sort);

    ListElementFact* peak(){return root;};

    void iterate();
};

class PotentialCalculatorGreedy : public PotentialCalculator{

//    bool average_pdbh;
    FactList delta_list;
    int num_iterations;
    std::vector<std::vector<double>> potentials;
    std::vector<std::vector<double>> deltas;
    double eps;
    bool handle_dead_ends;

    bool iterate();

public:
    PotentialCalculatorGreedy(const Options &opts);
    ~PotentialCalculatorGreedy()=default;

    virtual std::vector<std::vector<double>>get_potentials(
        const std::vector<pdbs::PatternDatabase> &pdbs,
        const std::shared_ptr<AbstractTask> &task) override;
};
}

#endif
