#ifndef POTENTIALS_POTENTIAL_CALCULATOR_ALGEBRAIC_H
#define POTENTIALS_POTENTIAL_CALCULATOR_ALGEBRAIC_H

#include "potential_calculator.h"

#include "../pdbs/types.h"
#include "../pdbs/pdb_h_tensor.h"
#include "../pdbs/pattern_database.h"
//#include "../option_parser.h"

#include <vector>

namespace pdbs{
struct comp
{
    bool operator()(PatternDatabase &a, PatternDatabase &b)
    {
        return a.compute_mean_finite_h() < b.compute_mean_finite_h();
    }
};
}

namespace potentials{
class PotentialCalculatorAlgebraic : public PotentialCalculator{
    std::vector<std::vector<double>> potentials;
    bool handle_dead_ends;
    int max_num_patterns;

private:
    std::vector<std::vector<double>> make_Atb(
    const pdbs::PDBhTensor h_tensor,
    const pdbs::Pattern pattern,
    const std::vector<size_t> domain_sizes);
    std::vector<std::vector<std::vector<double>>> make_AtA(
    const pdbs::Pattern pattern,
    const std::vector<size_t> domain_sizes);

public: 
    PotentialCalculatorAlgebraic(const Options &opts);
    ~PotentialCalculatorAlgebraic()=default;

    virtual std::vector<std::vector<double>>get_potentials(
        const std::vector<pdbs::PatternDatabase> &pdbs,
        const std::shared_ptr<AbstractTask> &task) override;
};
}

#endif
