#ifndef POTENTIALS_POTENTIAL_CALCULATOR_H
#define POTENTIALS_POTENTIAL_CALCULATOR_H

#include "../option_parser.h"
#include "../task_proxy.h"
#include "../pdbs/types.h"

#include <vector>

namespace potentials {
/*
  Interface for calculating the potentials of a potential function from
  several pattern-datadases.
*/
class PotentialCalculator {

public:
    PotentialCalculator();
    ~PotentialCalculator()=default;

/*
  Does the actual calculation. The first index of the result is the variable number
  and the second is its value.
*/
    virtual std::vector<std::vector<double>>get_potentials(
        const std::vector<pdbs::PatternDatabase> &pdbs,
        const std::shared_ptr<AbstractTask> &task)=0;
};
}

#endif
