#ifndef POTENTIALS_PDB_BASED_POTENTIAL_HEURISTICS_H
#define POTENTIALS_PDB_BASED_POTENTIAL_HEURISTICS_H

#include "../heuristic.h"
#include "../option_parser.h"

#include "potential_function.h"
#include "potential_heuristic.h"


namespace potentials {

std::unique_ptr<PotentialFunction> create_pdb_based_potential_function(
        const options::Options &opts);

class PDBPotentialHeuristic : public PotentialHeuristic {

protected:
    virtual int compute_heuristic(const GlobalState &global_state) override;

public:
    PDBPotentialHeuristic(const options::Options &opts)
        : PotentialHeuristic(
            Heuristic::default_options(),
            create_pdb_based_potential_function(opts)){};
    ~PDBPotentialHeuristic()=default;
};
}
#endif
