#include "pdb_based_potential_heuristics.h"

#include "potential_function.h"
#include "potential_heuristic.h"
#include "potential_calculator.h"
//#include "potential_max_heuristic.h"
#include "util.h"

//#include "../option_parser.h"
//#include "../operator_cost.h"
#include "../plugin.h"

#include "../pdbs/pattern_database.h"
//#include "../pdbs/types.h"
#include "../pdbs/pattern_generator.h"
#include "../pdbs/pattern_generator_simple.h"

//#include <memory>
#include <vector>

using namespace std;

namespace potentials {
/*TODO: use pdbs::PatternGeneratorSimple
  Generates a pattern of size pattern_size with var_id in it and some of the
  goal_vars.
*/
/*static pdbs::Pattern generate_simple_pattern(const int &var_id,
        const vector<int> &goal_vars, const size_t &pattern_size){
    assert(pattern_size<=goal_vars.size());
    if(pattern_size>goal_vars.size()){
        cerr << "Simple pattern generation failed, pattern_size is too large."
                << endl;
        utils::exit_with(utils::ExitCode::CRITICAL_ERROR);
    }
    /----------------------debug-------------------------
    size_t goal_size = goal_vars.size();
    cout << "goal_vars.size(): " << goal_size << "\n";
    cout << "pattern_size :" << pattern_size << "\n";
    cout << "goal_vars: {";
    for (size_t i=0; i<goal_size-1;++i){
        cout << goal_vars[i] << ", ";
    }
    cout << goal_vars[goal_size-1] << "}\n";
    //-----------------end debug--------------------------/
    pdbs::Pattern pattern;
    pattern.resize(pattern_size);
    size_t j = 0;
    int goal_var;
    bool needVar = true;
    for (size_t i = 0; i<pattern_size; ++i){
        goal_var = goal_vars[j];
        if (needVar) {
            if (i==pattern_size-1){
                pattern[i]=var_id;
                needVar = false;
            }
            else{
                if (var_id<=goal_var){
                    pattern[i] = var_id;
                    needVar = false;
                    if (var_id == goal_var)
                        ++j;
                }
                else{
                    pattern[i]=goal_var;
                    ++j;
                }
            }
        }
        else {
            pattern[i] = goal_var;
            j++;
        }
    }
    //----------------debug--------------------
    cout << "Pattern for var_" << var_id << " :  {";
    for (size_t i=0; i<pattern_size-1;++i){
        cout << pattern[i] << ", ";
    }
    cout << pattern[pattern_size-1] << "}\n";
    //--------------end debug-----------------/
    return pattern;
}*/

/*
  Generates the potential-function using average pdb-h of patterns of size
  pattern_size.
*/
unique_ptr<PotentialFunction> create_pdb_based_potential_function(
        const Options &opts){
    //size_t pattern_size =static_cast<size_t>(opts.get<int>("pattern_size"));
    size_t max_num_patterns =static_cast<size_t>(opts.get<int>("max_num_patterns"));
    unique_ptr<PotentialFunction> function;
    TaskProxy task_proxy(*g_root_task());
    VariablesProxy vars = task_proxy.get_variables();
    vector<int> important_vars = make_important_vars_list(task_proxy, vars);
    vector<vector<double>> fact_potentials;
    int num_vars = vars.size();
    fact_potentials.resize(num_vars);
    int var_id;
    //*-----------------------debug-----------------------------
    cout << "Generating patterns\n";
    //---------------------end debug----------------------------*/
    shared_ptr<pdbs::PatternCollectionGenerator> generator
        = opts.get<shared_ptr<pdbs::PatternCollectionGenerator>>
        ("pattern_generator");
    pdbs::PatternCollectionInformation pattern_coll_info 
            = generator->generate(g_root_task());
    shared_ptr<pdbs::PatternCollection> generated_patterns
            = pattern_coll_info.get_patterns();
    /*for (VariableProxy var:vars){
        var_id = var.get_id();
        bool found = false;
        for (pdbs::Pattern gen_pattern:*generated_patterns){
            for (int id:gen_pattern){
                if (id == var_id && gen_pattern.size() == pattern_size){
                    found = true;
                    break;
                }
            }
        }
        if (!found){
            cout << "Missing pattern with var_" << var_id << " in it.\n";
            cout << "Falling back on simple pattern generation.\n";
            //TODO: use pdbs::PatternGeneratorSimple
            generated_patterns->push_back(generate_simple_pattern(
                var_id, important_vars,pattern_size));
        }
    }*/
    //*-----------------------debug------------------------------
    cout << "Patterns generated\n";
    //----------------------end debug----------------------------*/
    vector<pdbs::PatternDatabase> pdbs;
    if(max_num_patterns<generated_patterns->size()){
        pdbs=filter_patterns(*generated_patterns, max_num_patterns, task_proxy);
    }
    else{
        for(pdbs::Pattern pattern:(*generated_patterns)){
            pdbs.push_back(pdbs::PatternDatabase(task_proxy, pattern));
        }
    }
    cout << "initializing potential calculator\n";
    shared_ptr<PotentialCalculator> pot_calc
        = opts.get<shared_ptr<PotentialCalculator>>("potential_calculator");
    cout << "generating potentials\n";
    fact_potentials=pot_calc->get_potentials(pdbs,g_root_task());
    cout << "potentials generated\n";
//---------------------------------debug--------------------------------------------
    cout << "potentials:\n";
    size_t domain_size;
    for (VariableProxy var:vars){
        var_id = var.get_id();
        cout << "var_" << var_id << ":\n";
        domain_size = var.get_domain_size();
        for (size_t val=0; val<domain_size; ++val){
            cout<<"   val:"<<val<<" potential: "
                <<fact_potentials[var_id][val]<<"\n";
        }
    }
//--------------------------------end debug-----------------------------------------
    function = utils::make_unique_ptr<PotentialFunction>(fact_potentials);
    return function;
}

int PDBPotentialHeuristic::compute_heuristic(const GlobalState &global_state) {
    const State state = convert_global_state(global_state);
    int result = max(0,function->get_value(state));
    return result;
}

static Heuristic *_parse(OptionParser &parser) {
    parser.document_synopsis(
        "PDB-based potential heuristics",
        "Potential heuristic approximating pdb heuristics");

    parser.add_option<int>(
        "pattern_size",
        "size of the pattern of the pdbs used for calculating potentials",
        "3",
        Bounds("2", "infinity"));
    parser.add_option<shared_ptr<pdbs::PatternCollectionGenerator>>(
        "pattern_generator",
        "pattern generation method",
        "systematic(pattern_max_size=3)");
    parser.add_option<shared_ptr<PotentialCalculator>>(
        "potential_calculator",
        "potential calculation method",
        "greedy()");
    parser.add_option<int>(
        "max_num_patterns",
        "Maximal number of patterns to be used.",
        "infinity",
        Bounds("1", "infinity"));

    Options opts = parser.parse();
    if (parser.dry_run())
        return nullptr;

    return new PDBPotentialHeuristic(opts);
}

static Plugin<Heuristic> _plugin("pdb_based_potentials", _parse);
}
