#ifndef PDBS_PDB_H_TENSOR_H
#define PDBS_PDB_H_TENSOR_H

#include "types.h"
#include "pattern_database.h"

#include "../utils/system.h"

#include <vector>

namespace pdbs{

class PDBhTensor{
    Pattern pattern;
    double* h_values;
    std::vector<size_t> domain_sizes;
    size_t dom_size_prod;
    bool handle_dead_ends;

private:
    size_t get_var_nr(int var_id);
    void get_all_h(const PatternDatabase &pdb,Pattern free_vars,
        std::vector<int> values);
public:
    PDBhTensor(){};
    PDBhTensor(const PatternDatabase &pdb,const VariablesProxy &vars,
        const bool &handle_dead_ends);
    ~PDBhTensor()=default;

    double &operator[](std::vector<int> values) const;
    double get(std::vector<int> values) const;
    double get_total_sum() const;
};
}
#endif

