#ifndef PDBS_PATTERN_GENERATOR_SIMPLE_H
#define PDBS_PATTERN_GENERATOR_SIMPLE_H

#include "pattern_generator.h"
#include "types.h"

namespace options {
class Options;
}

namespace pdbs {
class PatternGeneratorSimple : public PatternGenerator {
    Pattern pattern;
    int main_var;
    int pattern_size;
    
    std::vector<int> make_important_vars_list(
                                const TaskProxy &task_proxy,
                                const VariablesProxy &vars);
public:
    explicit PatternGeneratorSimple(const options::Options &opts);
    ~PatternGeneratorSimple() = default;

    Pattern generate(const std::shared_ptr<AbstractTask> &task) override;
};
}

#endif
