#include "pattern_generator_simple.h"
#include "pattern_database.h"

#include "../option_parser.h"
#include "../plugin.h"
#include "../task_proxy.h"


using namespace std;

namespace pdbs {

vector<int> PatternGeneratorSimple::make_important_vars_list(
                                        const TaskProxy &task_proxy,
                                        const VariablesProxy &vars){
//    TaskProxy task_proxy(*task);
    int num_vars = vars.size();
    vector<int> result;
    vector<double> importance;
    importance.resize(num_vars);
    result.resize(num_vars);
    Pattern pattern;
    pattern.resize(1);
    for (int i=0; i<num_vars; ++i){
        pattern[0]=i;
        PatternDatabase pdb(task_proxy, pattern);
        importance[i] = pdb.compute_mean_finite_h();
        result[i]=i;
    }
    for (int j=num_vars-1; j>0; --j){
        for (int i=0; i<j; ++i){
            if(importance[i]<importance[i+1]){
                double tempd = importance[i];
                importance[i]=importance[i+1];
                importance[i+1]=tempd;
                int tempi=result[i];
                result[i]=result[i+1];
                result[i+1]=tempi;
            }
        }
    }
    return result;
}

PatternGeneratorSimple::PatternGeneratorSimple(const Options &opts)
        : main_var(opts.get<int>("main_var")),
          pattern_size(opts.get<int>("pattern_size")){
}

Pattern PatternGeneratorSimple::generate(const shared_ptr<AbstractTask> &task) {
    TaskProxy task_proxy(*task);
    VariablesProxy vars = task_proxy.get_variables();
    vector<int> important_vars = make_important_vars_list(task_proxy, vars);
    assert(pattern_size<=static_cast<int>(important_vars.size()));
    if(pattern_size>static_cast<int>(important_vars.size())){
        cerr << "Simple pattern generation failed, pattern_size is too large."
                << endl;
        utils::exit_with(utils::ExitCode::CRITICAL_ERROR);
    }
    /*//----------------------debug-------------------------
    size_t important_vars_size = important_vars.size();
    cout << "important_vars.size(): " << important_vars_size << "\n";
    cout << "pattern_size :" << pattern_size << "\n";
    cout << "important_vars: {";
    for (size_t i=0; i<goal_size-1;++i){
        cout << important_vars[i] << ", ";
    }
    cout << important_vars[important_vars_size-1] << "}\n";
    //-----------------end debug--------------------------*/
    pattern.resize(pattern_size);
    int j = 0;
    int goal_var;
    bool needVar = true;
    for (int i = 0; i<pattern_size; ++i){
        goal_var = important_vars[j];
        if (needVar) {
            if (i==pattern_size-1){
                pattern[i]=main_var;
                needVar = false;
            }
            else{
                if (main_var<=goal_var){
                    pattern[i] = main_var;
                    needVar = false;
                    if (main_var == goal_var)
                        ++j;
                }
                else{
                    pattern[i]=goal_var;
                    ++j;
                }
            }
        }
        else {
            pattern[i] = goal_var;
            j++;
        }
    }
    cout << "Pattern for var_" << main_var << " :  {";
    for (int i=0; i<pattern_size-1;++i){
        cout << pattern[i] << ", ";
    }
    cout << pattern[pattern_size-1] << "}\n";
    return pattern;
}

static shared_ptr<PatternGenerator> _parse(OptionParser &parser) {
    parser.add_option<int>(
        "pattern_size",
        "size of the pattern",
        "3",
        Bounds("2", "infinity"));
    parser.add_option<int>(
        "main_var",
        "this variable is garanteed to be in pattern",
        "0",
        Bounds("0", "infinity"));

    Options opts = parser.parse();
    if (parser.dry_run())
        return nullptr;

    return make_shared<PatternGeneratorSimple>(opts);
}

static PluginShared<PatternGenerator> _plugin("simple", _parse);
}
