#ifndef MIASM_MERGE_AND_SHRINK_ABSTRACTION_H
#define MIASM_MERGE_AND_SHRINK_ABSTRACTION_H

#include "types.h"

#include "../../task_proxy.h"

#include "../../options/options.h"

#include <memory>
#include <string>
#include <vector>
#include <map>

namespace options {
class Options;
}

namespace merge_and_shrink {
class FactoredTransitionSystem;
//class LabelReduction;
//class MergeStrategy;
//class ShrinkStrategy;
class VarSetInfoRegistry;
enum class SymmetryUsage {// which form of symmetries for MIASM
    //use no symmetries
    NONE,
    //use simple symmetries algorithm
    SIMPLE,
    //use limited symmetries algorithm
    LIMITED
};

class MiasmAbstraction {
    std::shared_ptr<AbstractTask> task;
    TaskProxy task_proxy;
//    std::shared_ptr<MergeStrategy> merge_strategy;
//    std::shared_ptr<ShrinkStrategy> shrink_strategy;
//    std::shared_ptr<LabelReduction> label_reduction;
    bool use_symmetries;
public:
    MiasmAbstraction(const options::Options &opts);
    static std::string option_key();
    static std::string plugin_key();
    //void setOptions(const options::Options &opts);


    const options::Options *options;
    //std::vector<int> abstraction_map;
    std::map<int,mst::var_set_t> variable_map;
    std::map<int,mst::var_set_t> symmetry_order;
    std::vector<int> used_indexes_for_symmetries;
    std::shared_ptr<FactoredTransitionSystem> fts;
    std::map<mst::var_set_t, int> cache;
    void release_cache();
    void release_cache(const mst::var_set_t &var_set);

    int build_transition_system(const mst::var_set_t &G,
        std::vector<mst::var_set_t> &newly_built,
        const VarSetInfoRegistry &vsir);
    void build_atomic_transition_system(std::vector<int> &abstraction_map, options::Options &opts);
    bool is_index_already_merged(int index);
    mst::var_set_t get_underlying_variables(int index);
    mst::var_set_t get_symmetry_order(int index);
    bool is_index_merged(int index);
    bool is_disjoint(std::vector<int> &indexes);

};
}

#endif // MIASM_MERGE_AND_SHRINK_ABSTRACTION_H
