#include "miasm_mas.h"

#include "subset_info.h"

#include "../factored_transition_system.h"
#include "../fts_factory.h"
#include "../label_reduction.h"
#include "../merge_strategy.h"
#include "../shrink_strategy.h"
#include "../transition_system.h"

#include "../../heuristic.h"
#include "../../option_parser.h"
#include "../../plugin.h"
//#include "../../utilities.h"
#include "../../options/options.h"
#include "../symmetries/symmetry_group.h"

#include <cassert>
#include <iostream>
#include <string>
#include <utility>
#include <vector>
#include <limits>

using namespace std;

namespace merge_and_shrink {
using namespace mst;

MiasmAbstraction::MiasmAbstraction(const Options &opts)
    : task(get_task_from_options(opts)),
      task_proxy(*task),
//      shrink_strategy(opts.get<shared_ptr<ShrinkStrategy>>("shrink_strategy")),
      fts(nullptr) {
//    merge_strategy->initialize(task);
//    if (opts.contains("label_reduction")) {
//        label_reduction = opts.get<shared_ptr<LabelReduction>>("label_reduction");
//        label_reduction->initialize(task_proxy);
//    }
}

string MiasmAbstraction::option_key() {
    return "abstraction";
}

string MiasmAbstraction::plugin_key() {
    return "miasm_merge_and_shrink";
}

void MiasmAbstraction::release_cache(const var_set_t &var_set) {
//    cerr << __PRETTY_FUNCTION__ << endl;
    assert(cache.count(var_set));
    int ts_index = cache[var_set];
    // TODO: erase vector position and shift all others?
    fts->remove(ts_index);
    cache.erase(var_set);
}

void MiasmAbstraction::release_cache() {
//    cerr << __PRETTY_FUNCTION__ << endl;
    for (map<var_set_t, int>::iterator i = cache.begin();
         i != cache.end(); ++i) {
//        cerr << i->first << endl;
        int ts_index = i->second;
        // TODO: erase vector position and shift all others?
        if(fts->is_active(ts_index)){
            fts->remove(ts_index);
        }
    }
    map<var_set_t, int>().swap(cache);
}

bool MiasmAbstraction::is_disjoint(vector<int> &indexes){

    for(unsigned int i=0;i<indexes.size();i++){
        for(unsigned int j=0;j<used_indexes_for_symmetries.size();j++){
            if(indexes[i]==used_indexes_for_symmetries[j]){
                return false;
            }
        }
    }
    for(unsigned int i=0;i<indexes.size();i++){
        used_indexes_for_symmetries.push_back(indexes[i]);
    }
    return true;
}

void MiasmAbstraction::build_atomic_transition_system(vector<int> &abstraction_map, options::Options &opts){


    assert(!fts);
    fts = make_shared<FactoredTransitionSystem>(
                create_factored_transition_system(task_proxy, false));
    for(int i=0;i<fts->get_size();i++){
        abstraction_map.push_back(i);
    }
    //bool use_symmetries=opts.get<bool>("use_symmetries");
    SymmetryUsage use_symmetries=SymmetryUsage(opts.get_enum("use_symmetries"));
    if(use_symmetries!=SymmetryUsage::NONE){

        double time_limit=0.0;
        opts.set<double>("bliss_time_limit", time_limit);
        std::vector<std::pair<int, int>> merge_order;
        SymmetryGroup symmetry_group(opts);
        //symmetry_group.get_symmetry_generators();
        symmetry_group.find_and_apply_symmetries(*fts, merge_order);
        if(use_symmetries==SymmetryUsage::LIMITED){
            std::vector<std::vector<int>> final_symmetries;
            //unsigned int max_number=150000;
            unsigned int max_number=opts.get<int>("limited_max_states");
            std::vector<std::vector<int>> ordered_symmetry_generators;
            symmetry_group.get_symmetry_generators(ordered_symmetry_generators);
            for(unsigned int i=0;i<ordered_symmetry_generators.size();i++){
                vector<int> indexes=ordered_symmetry_generators[i];
                unsigned int number_of_affected_states=1;
                bool max_reached=false;
                for(unsigned int j=0;j<indexes.size();j++){
                    try{
                        int current_index=fts->get_ts(indexes[j]).get_size();
                        if(current_index==0){
                            current_index=1;
                        }
                        //cout<<"index: "<<current_index<<" affected: "<<number_of_affected_states<<endl;

                        number_of_affected_states=number_of_affected_states*current_index;
                        if(number_of_affected_states>max_number){
                            max_reached=true;
                            break;
                        }
                    }catch(std::overflow_error& ex){
                        number_of_affected_states=std::numeric_limits<unsigned int>::max();
                        cout<<ex.what()<<endl;

                    }
                        //cout<<"number_of_affected_states: "<<number_of_affected_states<<endl;

                }
                if(!max_reached&&is_disjoint(ordered_symmetry_generators[i])){
                    //cout<<"true"<<endl;
                    final_symmetries.push_back(ordered_symmetry_generators[i]);
                }

            }
            for(unsigned int i=0;i<final_symmetries.size();i++){
                cout<<"final vector i: "<<i<<endl;
                vector<int> symmetry=final_symmetries[i];
                for(unsigned int j=0;j<symmetry.size();j++){
                    cout<<symmetry[j]<<endl;
                }
            }
            //assert(false);
            for(unsigned int i=0;i<final_symmetries.size();i++){
                //cout<<"i: "<<i<<endl;
                merge_order.clear();
                symmetry_group.get_merge_order_for_generator(*fts,symmetry_group.get_symmetry_generator_index(final_symmetries[i]),merge_order);
                for(unsigned int i =0;i<merge_order.size();i++){
                    var_set_t var_set;
                    var_set.insert(merge_order[i].first);
                    var_set.insert(merge_order[i].second);

                    int new_index=fts->merge(merge_order[i].first,merge_order[i].second);
                    symmetry_order.insert(pair<int,var_set_t>(new_index,var_set));
                    for(unsigned int j=0;j<abstraction_map.size();j++){
                        if(merge_order[i].first==abstraction_map[j] || merge_order[i].second==abstraction_map[j]){
                            abstraction_map[j]=new_index;
                        }
                    }
                    abstraction_map.push_back(new_index);
                    //cout<< "new index "<<new_index<<" , new size: "<<fts->get_size()<<endl;
                    //cache.insert(pair<var_set_t, int>(G, new_index));
                }
            }
            //cout<<"merge_order size2: "<<merge_order.size()<<endl;
        }
        if(use_symmetries==SymmetryUsage::SIMPLE){
           for(unsigned int i =0;i<merge_order.size();i++){
               var_set_t var_set;
               var_set.insert(merge_order[i].first);
               var_set.insert(merge_order[i].second);

               int new_index=fts->merge(merge_order[i].first,merge_order[i].second);
               symmetry_order.insert(pair<int,var_set_t>(new_index,var_set));
               for(unsigned int j=0;j<abstraction_map.size();j++){
                   if(merge_order[i].first==abstraction_map[j] || merge_order[i].second==abstraction_map[j]){
                       abstraction_map[j]=new_index;
                   }
               }
               abstraction_map.push_back(new_index);
               cout<< "new index "<<new_index<<" , new size: "<<fts->get_size()<<endl;
               //cache.insert(pair<var_set_t, int>(G, new_index));
           }

        }

        //assert(false);
        /*for(unsigned int i =0;i<merge_order.size();i++){
            var_set_t var_set;
            var_set.insert(merge_order[i].first);
            var_set.insert(merge_order[i].second);

            int new_index=fts->merge(merge_order[i].first,merge_order[i].second);
            symmetry_order.insert(pair<int,var_set_t>(new_index,var_set));
            for(unsigned int j=0;j<abstraction_map.size();j++){
                if(merge_order[i].first==abstraction_map[j] || merge_order[i].second==abstraction_map[j]){
                    abstraction_map[j]=new_index;
                }
            }
            abstraction_map.push_back(new_index);
            cout<< "new index "<<new_index<<" , new size: "<<fts->get_size()<<endl;
            //cache.insert(pair<var_set_t, int>(G, new_index));
        }*/

    }

    /* remove the atomic abstraction if its variable is not involved */
    for(unsigned int i=0;i<abstraction_map.size();i++){
        cout<<"index: "<<i<<"value: "<<abstraction_map[i]<<endl;
    }

    for (var_t i = 0; i < fts->get_size(); ++i) {


        if(fts->is_active(i)){
            const vector<int> &variables =fts->get_ts(i).get_incorporated_variables();
            var_set_t s = var_set_t(variables.begin(), variables.end());
            for (var_set_t::iterator it = s.begin();
                 it != s.end(); ++it){
                //cout<<"i: "<<i<<" cache: "<< *(it) <<endl;
            }
            //TODO: put information of variable_map and symmetry_order in same data structure
            variable_map.insert(pair<int,var_set_t>(i,s));
            assert(!cache.count(s));
            var_set_t out=variable_map[i];
            for (var_set_t::iterator it = out.begin();
                 it != out.end(); ++it){
                cout<<"i: "<<i<<" variable_set : "<< *(it) <<endl;
            }
            //newly_built.push_back(s);
            //            cerr << "new: " << s << endl;
            cache.insert(pair<var_set_t, int>(s, i));
        }
    }



    /*for (var_t i = 0; i < fts->get_size(); ++i) {

            var_set_t s = mst::singleton(i);
            for (var_set_t::iterator s2 = s.begin();
                 s2 != s.end(); ++s2){
                cout<<"i: "<<i<<" cache: "<< *(s2) <<endl;
            }
            assert(!cache.count(s));
            //newly_built.push_back(s);
//            cerr << "new: " << s << endl;
            cache.insert(pair<var_set_t, int>(s, i));
        }
        //assert(cache.count(G));
        //return cache[G];*/



}

/*void MiasmAbstraction::merge_symmetries(){

}*/

bool MiasmAbstraction::is_index_already_merged(int index){
    bool already_merged=false;
    if(variable_map.find(index)!=variable_map.end()){
        if(variable_map[index]!=mst::singleton(index)){
            already_merged=true;
        }
    }
    return already_merged;
}

var_set_t MiasmAbstraction::get_underlying_variables(int index){
    return variable_map[index];
}

bool MiasmAbstraction::is_index_merged(int index){
    if(symmetry_order.find(index)!=symmetry_order.end()){
        return true;
    }
    return false;
}

var_set_t MiasmAbstraction::get_symmetry_order(int index){
    return symmetry_order[index];
}


int MiasmAbstraction::build_transition_system(const var_set_t &G, vector<var_set_t> &newly_built,
    const VarSetInfoRegistry &vsir) {
    /*for (var_set_t::iterator it = G.begin();
         it != G.end(); ++it){
        cout<<" G: "<< *(it)<<" ";
    }
    cout<<" "<<endl;*/
    //TODO: change variable_map??
    /*if(variable_map.find(G)!=variable_map.end()){
        //cout<<"true"<<endl;
        assert(fts);
        return cache[variable_map[G]];
    }*/
    if(G.size()==1 && is_index_already_merged(*G.begin())){
        assert(fts);
        return cache[get_underlying_variables(*G.begin())];
    }
    assert(!G.empty());
    if (cache.count(G)) {
//        cerr << "old: " << G << endl;
        assert(fts);
        //cout<<"cache[g]: "<<cache[G]<<endl;
        return cache[G];
    }


    var_set_t left_set, right_set;

    if (vsir.contain(G)) {
        size_t pl = vsir[G].parent.first;
        size_t pr = vsir[G].parent.second;
        if (pl != numeric_limits<size_t>::max() &&
            pr != numeric_limits<size_t>::max()) {
            left_set = vsir[pl].variables;
            right_set = vsir[pr].variables;
        }
    }
    if (left_set.empty() && right_set.empty()) {
        // TODO: currently the abstraction on varset is constructed by simply
        // merging corresponding atomic abstractions in the default order
        // without any shrinking or label reduction
        // re-implement this to allow arbitrary merging, shrinking and label reduction
        vector<var_t> ordered(G.begin(), G.end());
        left_set = set<var_t>(ordered.begin(), ordered.end() - 1);
        right_set.insert(ordered.back());
        //left_set = set<var_t>(ordered.begin()+1, ordered.end());
        //right_set.insert(ordered.front());

//        if (!vsir.contain(left_set))
//            vsir.add(left_set);
//        if (!vsir.contain(right_set))
//            vsir.add(right_set);

//        if (!vsir.contain(G)) {
//            vsir.add(G);
//            vsir[G].parent = make_pair<size_t, size_t>(
//                vsir.idx(left_set), vsir.idx(left_set));
//        }
    }

//    cerr << left_set << ", " << right_set << endl;

    int left_ts_index = build_transition_system(left_set,
                                                newly_built, vsir);
    int right_ts_index = build_transition_system(right_set,
                                                 newly_built, vsir);

    //cout<<"left index: "<<left_ts_index<<" right index: "<<right_ts_index<<endl;

    int new_ts_index = fts->merge(left_ts_index, right_ts_index, false, false);

    newly_built.push_back(G);
    cache.insert(pair<var_set_t, int>(G, new_ts_index));
    assert(cache.count(G));


//    cerr << "new: " << G << endl;
    return cache[G];
}

static MiasmAbstraction *_parse(OptionParser &parser) {
    // Merge strategy option.
//    parser.add_option<shared_ptr<MergeStrategy>>(
//        "merge_strategy",
//        "See detailed documentation for merge strategies. "
//        "We currently recommend merge_dfp.");

//    // Shrink strategy option.
//    parser.add_option<shared_ptr<ShrinkStrategy>>(
//        "shrink_strategy",
//        "See detailed documentation for shrink strategies. "
//        "We currently recommend shrink_bisimulation.");

    // Label reduction option.
//    parser.add_option<shared_ptr<LabelReduction>>(
//        "label_reduction",
//        "See detailed documentation for labels. There is currently only "
//        "one 'option' to use label_reduction. Also note the interaction "
//        "with shrink strategies.",
//        OptionParser::NONE);

    // For AbstractTask
    Heuristic::add_options_to_parser(parser);
    Options opts = parser.parse();
    if (parser.dry_run()) {
        return 0;
    } else {
        return new MiasmAbstraction(opts);
    }
}

static Plugin<MiasmAbstraction> _plugin(MiasmAbstraction::plugin_key(), _parse);
}
