#include "merge_scoring_function_test.h"

#include "factored_transition_system.h"
#include "transition_system.h"
#include "utils.h"

#include "../options/option_parser.h"
#include "../options/plugin.h"

using namespace std;

namespace merge_and_shrink {
vector<double> MergeScoringFunctionTest::compute_scores(
        // MergeScoringFunctionCausalConnection
    FactoredTransitionSystem &fts,
    const vector<pair<int, int>> &merge_candidates) {
    vector<double> scores;
    scores.reserve(merge_candidates.size());
    for (pair<int, int> merge_candidate : merge_candidates ) {
        int ts_index1 = merge_candidate.first;
        int ts_index2 = merge_candidate.second;
        const vector<int> ts1_var_nos = fts.get_ts(ts_index1).get_incorporated_variables();
        const vector<int> ts2_var_nos = fts.get_ts(ts_index2).get_incorporated_variables();
        int edge_count = 0;
        for (int ts1_var_no : ts1_var_nos) {
            for (int ts2_var_no : ts2_var_nos) {
                edge_count += var_pair_causal_links[ts1_var_no][ts2_var_no];
            }
        }
        double max_possible_edges = ts1_var_nos.size() * ts2_var_nos.size() * 2;
        assert(max_possible_edges);

        // score value in [1,infinity]
        double score = -1;
        if (!edge_count) {
            score = INF;
        } else {
            score = max_possible_edges / static_cast<double>(edge_count);
        }
        scores.push_back(score);
    }
    return scores;
}

string MergeScoringFunctionTest::name() const {
    return "test";
}

static shared_ptr<MergeScoringFunction>_parse(options::OptionParser &parser) {
    parser.document_synopsis(
        "Goal relevance scoring",
        "This scoring function assigns a merge candidate a value of 0 iff at "
        "least one of the two transition systems of the merge candidate is "
        "goal relevant in the sense that there is an abstract non-goal state."
        "All other candidates get a score of positive infinity.");
    if (parser.dry_run())
        return nullptr;
    else
        return make_shared<MergeScoringFunctionTest>();
}

static options::PluginShared<MergeScoringFunction> _plugin("test", _parse);
}
