#ifndef EAGER_TUNNEL_SEARCH_H
#define EAGER_TUNNEL_SEARCH_H

#include <vector>

#include "open_lists/open_list.h"
#include "search_engine.h"
#include "search_space.h"
#include "state.h"
#include "timer.h"
#include "evaluator.h"
#include "search_progress.h"
#include "eager_search.h"

class Heuristic;
class Operator;
class ScalarEvaluator;
class Options;

class EagerTunnelSearch : public EagerSearch {
    // Search Behavior parameters
    bool reopen_closed_nodes; // whether to reopen closed nodes upon finding lower g paths
    bool do_pathmax; // whether to use pathmax correction
    bool use_multi_path_dependence;

    OpenList<StateID> *open_list;
    ScalarEvaluator *f_evaluator;

    std::vector<std::pair<const Operator *,std::vector<const Operator *> > > tunnelMap;

protected:
    virtual SearchStatus step();

    virtual void initialize();

public:
    EagerTunnelSearch(const Options &opts);

    void dump_search_space();
    bool inSmin(std::vector<Condition> cond, std::vector<Condition> last_cond, std::vector<Effect> last_eff);
    void create_tunnel_map();
    bool cond_is_in_effect(std::vector<Condition> pre2, std::vector<Effect> eff);
    bool has_pre_post(std::vector<Condition> pre2,std::vector<Effect> eff2,std::vector<Effect> eff);
    bool has_same_effects(std::vector<Effect> eff2,std::vector<Effect> eff);
    bool has_prevail(std::vector<Condition> pre2,std::vector<Effect> eff2,std::vector<Effect> eff);
};

#endif
