#ifndef EAGER_PB_SEARCH_H
#define EAGER_PB_SEARCH_H

#include <vector>

#include "open_lists/open_list.h"
#include "search_engine.h"
#include "search_space.h"
#include "state.h"
#include "timer.h"
#include "evaluator.h"
#include "search_progress.h"
#include "eager_search.h"
#include "rng.h"

class Heuristic;
class Operator;
class ScalarEvaluator;
class Options;

struct partitionEntry{
    const Operator *op;
    bool is_private;//1 if private; 0 if public
    int partition;//number of partition op belongs
};

class EagerPbSearch : public EagerSearch {
    // Search Behavior parameters
    bool reopen_closed_nodes; // whether to reopen closed nodes upon finding lower g paths
    bool do_pathmax; // whether to use pathmax correction
    bool use_multi_path_dependence;

    OpenList<StateID> *open_list;
    ScalarEvaluator *f_evaluator;
    std::vector<partitionEntry> partition_map;

    std::vector<std::pair<const Operator *,std::vector<const Operator *> > > action_graph;

protected:
    virtual SearchStatus step();

    virtual void initialize();

public:
    EagerPbSearch(const Options &opts);


    void create_partition_map();
    bool check_if_private(const Operator *op);
    std::vector<const Operator *> prunePartition(std::vector<const Operator *> applicable_ops, int partition);
    void dump_search_space();
    bool is_neighbour(const Operator *op, const Operator *op2);
    void localsearch();
    int getNumberOfPrivates();
};

#endif
