#include "sum_evaluator.h"

#include "../plugins/plugin.h"

#include <cassert>
#include <limits>

using namespace std;

namespace sum_evaluator {
SumEvaluator::SumEvaluator(const plugins::Options &opts)
    : CombiningEvaluator(opts) {
}

SumEvaluator::~SumEvaluator() {
}

int SumEvaluator::combine_values(const vector<int> &values) {
    int result = 0;
    for (int value : values) {
        assert(value >= 0);
        result += value;
        assert(result >= 0); // Check against overflow.
    }
    return result;
}

static shared_ptr<Evaluator> _parse(OptionParser &parser) {
    {
        parser.document_synopsis(
            "Sum evaluator",
            "Calculates the sum of the sub-evaluators.");

        combining_evaluator::add_combining_evaluator_options_to_parser(parser);
    }
    Options opts = parser.parse();
    opts.verify_list_non_empty<shared_ptr<Evaluator>>("evals");
    if (parser.dry_run())
        return nullptr;
    else
        return make_shared<SumEvaluator>(opts);
}

static Plugin<Evaluator> _plugin("sum", _parse, "evaluators_basic");
}
