# laura maria engist, 2025
# script to convert the automatically created runhistory file from SMAC into the format necessary for deepcave

import json
import sys

runhistory = sys.argv[1] # input runhistory file; provide when executing the script
runhistory_converted = sys.argv[2] # input file for output; provide when executing the script

with open(runhistory, "r") as f:
    data = json.load(f)

    configs = data.get("configs", {})
    config_origins = data.get("config_origins", {})

    converted_data = {
        "stats": {
            "submitted": data["stats"]["submitted"],
            "finished": data["stats"]["finished"],
            "running": data["stats"]["running"]
        },
        "data": [],
        "configs": configs,
        "config_origins": config_origins 
    }

    for entry in data["data"]:
        converted_entry = [
            entry["config_id"],
            entry.get("instance", None),
            entry["seed"],
            entry.get("budget", None),
            entry["cost"],
            entry["time"],
            entry["status"],
            entry["starttime"],
            entry["endtime"],
            entry["additional_info"]
        ]
        converted_data["data"].append(converted_entry)
            
    with open(runhistory_converted, "w") as f:
        json.dump(converted_data, f, indent=4)