# laura maria engist, 2025
# script to run create_alignments_and_rocx.py on a slurm cluster
# Run as ./sbatch_run_smac.sh <job_name> <reservation> <path_to_virtual_environment> <mmseqs_file> <output_file> <gap_open> <gap_extension> <mat_file> <sequences_fasta>

# Retrieve command name from the command line
JOB_NAME=$1
RESERVATION=$2
VIRTUAL_ENVIRONMENT=$3 # path to the virtual environment
MMSEQS_FILE=$4 # path to the mmseqs2 .m8 file
OUTPUT_FILE=$5 # path to the output file to store .rocx output
GAP_OPEN=$6 # gap open penalty
GAP_EXTENSION=$7 # gap extend penalty
MAT_FILE=$8 # path to the matrix file as .out file
SEQUENCES_FASTA=$9 # path to the embedded sequences as .fasta file

# Use a heredoc to create the script
cat << EOF | sbatch
#!/bin/bash
#SBATCH --job-name="$JOB_NAME"
#SBATCH --nodes=1        
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=4
#SBATCH --mem-per-cpu=60G
#SBATCH --partition=a100
#SBATCH --output=myrun.o%j
#SBATCH --error=myrun.e%j
#SBATCH --qos=gpu1week
#SBATCH --reservation="$RESERVATION"

source $VIRTUAL_ENVIRONMENT/bin/activate
python /evaluation/auc_plots/create_alignments_and_rocx.py $MMSEQS_FILE $OUTPUT_FILE $GAP_OPEN $GAP_EXTENSION $MAT_FILE $SEQUENCES_FASTA
EOF