# laura maria engist, 2025
# script to calculate lambda for a custom subsitution matrix (cma)
# g++ -g -O0 -shared -fPIC -o liblambda.so lambda_for_cma.cpp
# python lambda_for_cma.py

import re
import numpy as np
import math
from scipy.linalg import lu_factor, lu_solve
from evotuner import constants
import os

class LambdaForCMA:
    def __init__(self, matrix_array, directory_experiment):
        self.matrix = matrix_array
        self.directory_experiment = directory_experiment
    
    '''
    Calculate lambda for cma
    '''
    def calculate_lambda(self):
        m = np.array(self.matrix)
        m = m[:20, :20]
        import ctypes

        # load shared library
        lib = ctypes.CDLL(constants.CALCULATE_LAMBDA_SHARED_LIBRARY)

        lib.process_array.argtypes = [ctypes.POINTER(ctypes.c_double), ctypes.c_int]
        lib.process_array.restype = ctypes.c_double

        N = 20
        arr = np.array(m, dtype=np.double)
        arr_ptr = arr.ctypes.data_as(ctypes.POINTER(ctypes.c_double))

        calculated_lambda = -1.0
        calculated_lambda = lib.process_array(arr_ptr, N)
        if calculated_lambda < 0:
            return 0.34657 # default lambda of blosum62
        return calculated_lambda