# laura maria engist, 2025
# Run as ./sbatch_run_smac.sh <job_name> <nnp_smac_file>

# Retrieve command name from the command line
JOB_NAME=$1
NNP_SMAC_FILE=$2
mkdir -p logs/slurm
mkdir -p logs/wandb
mkdir -p data/vqvae_scop

# Use a heredoc to create the script
cat << EOF | sbatch
#!/bin/bash
#SBATCH --job-name="$JOB_NAME"
#SBATCH --cpus-per-task=4
#SBATCH --mem-per-cpu=10G
#SBATCH --time=14-00:00:00
#SBATCH --qos=2weeks
#SBATCH --output=logs/slurm/myrun.o%j
#SBATCH --error=logs/slurm/myrun.e%j

source $HOME/prog/alphabeta_env/venv/bin/activate
ml bzip2/1.0.8-GCCcore-13.2.0
python $NNP_SMAC_FILE
EOF