# laura maria engist, 2025
# script to run gap_penalties_qualAln_qualIdent.py on a slurm cluster
# Run as ./sbatch_run_smac.sh <job_name> <reservation> <path_to_virtual_environment>

# Retrieve command name from the command line
JOB_NAME=$1
RESERVATION=$2
VIRTUAL_ENVIRONMENT=$3 # path to the virtual environment

# Use a heredoc to create the script
cat << EOF | sbatch
#!/bin/bash
#SBATCH --job-name="$JOB_NAME"
#SBATCH --nodes=1        
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=4
#SBATCH --mem-per-cpu=100G
#SBATCH --partition=a100
#SBATCH --output=myrun.o%j
#SBATCH --error=myrun.e%j
#SBATCH --qos=gpu1day
#SBATCH --reservation="$RESERVATION"

source $VIRTUAL_ENVIRONMENT/bin/activate
python /evotuner/evaluation/gap_penalties_alignment_quality_or_identification/gap_penalties_qualAln_qualIdent.py
EOF