# laura maria engist, 2025
# script to compute the average time per trial for a given runhistory

import json

class AverageTimePerTrial:
    def __init__(self, runhistory):
        self.runhistory = runhistory
    
    ''''
    Compute average time per trial from runhistory json file
    '''
    def get_average_time_per_trial(self, ):
        total_time = 0
        total_trials = 0
        
        with open(self.runhistory, "r") as f:
            data = json.load(f)
            for entry in data["data"]:
                if "time" in entry:
                    if entry["time"] > 0.0:
                        total_time += entry["time"]
                        total_trials += 1
        
        if total_trials == 0:
            return 0
        seconds = total_time / total_trials
        minutes = seconds / 60
        hours = minutes / 60
        print(f"Average time per trial: {seconds:.2f} seconds, {minutes:.2f} minutes, {hours:.2f} hours")
        return total_time / total_trials

''' Example usage '''
path_to_runhistory_json_file = "" # path to runhistory json file of an experiment - stores all trials with their costs and times
average_time_per_trial = AverageTimePerTrial(path_to_runhistory_json_file)
print(average_time_per_trial.get_average_time_per_trial())