# laura maria engist, 2025
# script to check the error log after the end of an experiment --> know if we need to take action
# check for lines that do not start with 'CondaError' or '2025'

import os
import re

class CheckErrorLog:
    def __init__(self, path_experiment):
        self.path_experiment = path_experiment
    
    def load_error_logs(self):
        loggs = os.listdir(os.path.join(self.path_experiment, 'loggs'))
        error_loggs = dict()
        for file in loggs:
            if '.err' in file:
                zeilen = []
                with open(os.path.join(self.path_experiment, 'loggs', file), "r", encoding="utf-8") as f:
                    lines = f.readlines()
                
                error_logg = ""
                for line in lines:
                    if 'CondaError' not in line and '2025' not in line:
                        line = re.sub(r'\s+', '', line)
                        line = line.replace('^', '')
                        error_logg += line + "\n"
                error_loggs[file] = error_logg
        return error_loggs
    
    def alert_me(self):
        error_loggs = self.load_error_logs()
        if len(error_loggs) > 0:
            print("ATTENTION: ERROR LOG")
        else:
            print("ALL FINE - NO ERROR LOG")

''' example usage '''
#directory_experiment = ""
#check_log = CheckErrorLog(directory_experiment)
#check_log.alert_me()
    
