//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <gecode/int.hh>
#include <gecode/search.hh>
#include <gecode/set.hh>
#include <gecode/gist.hh>
#include <gecode/minimodel.hh>

#include "Subset.h"
#include "DisjointPatternDatabase/Index.h"

#ifndef GECODE_H
#define GECODE_H

class minCostCollection : public Gecode::MinimizeSpace{
protected:
	Gecode::IntVarArray x;
	Gecode::IntVar costs;

public:
	minCostCollection(SubsetContainer* subsets, const int &currrentTeam, const int &numberOfTeams,
			const int &upperBound, const int &travelHomeDistance, const Index &idx);
	minCostCollection(bool share, minCostCollection& s);

	virtual Space* copy(bool share) {
		return new minCostCollection(share,*this);
	}
	virtual Gecode::IntVar cost(void) const{
		return costs;
	}

	int* getX(void) const{
		int* exi = new int[x.size()];
		for(int i=0; i<x.size(); ++i){
			exi[i] = x[i].val();
		}
		return exi;
	}
};

#endif
