//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <vector>

#include "Subset.h"
#include "gecode.h"

using namespace Gecode;


minCostCollection::minCostCollection(SubsetContainer* subsets, const int &currrentTeam, const int &numberOfTeams,
		const int &upperBound, const int &travelHomeDistance, const Index &idx)
	: x(*this, subsets->size(), 0, 1), costs(*this, 0, Int::Limits::max){
	int containerSize = subsets->size();
	int* inSubset = NULL;
	bool* teamsToPlayAway = idx.getTeamsToPlayAway();

	//loop over all teams (expect current team)
	for(int k=0; k<(numberOfTeams); ++k){
		if (k != currrentTeam && teamsToPlayAway[k]) {
			inSubset = new int[containerSize];

			//loop over all subsets
			for(int j=0; j<containerSize; ++j){
				//check if team k is in subset j
				if(subsets->at(j)->teamInSubset(k)){
					inSubset[j] = 1;
				}else{
					inSubset[j] = 0;
				}
			}

			IntArgs a(containerSize,inSubset);
			delete[] inSubset;
			//linear constraints for all teams except the current team and the teams the current team has already played away (compare Easton et al. 2001, 2.1 Solution Methods)
			rel(*this, sum(a,x) == 1);
		}
	}
	delete[] teamsToPlayAway;

	int* isCriticalSubset = new int[containerSize];

	//loop over all subsets
	for(int j=0; j<containerSize; ++j){
		//check if subset j is critical
		if(subsets->at(j)->isCritical()){
			isCriticalSubset[j] = 1;
		}else{
			isCriticalSubset[j] = 0;
		}
	}

	IntArgs crit(containerSize,isCriticalSubset);
	delete[] isCriticalSubset;
	rel(*this, sum(crit,x) <= 1);


	IntArgs c(containerSize);
	//loop over all subsets to assign subsets minDistance to c
	for(int j=0; j<containerSize; ++j){
		c[j] = subsets->at(j)->getMinDistance();
	}

	IntArgs thd(1);
	thd[0] = travelHomeDistance;

	IntArgs isOnAwayTrip(1);
	if(idx.getNumberOfConsecutiveAwayGames() > 0
			&& idx.getRemainingAwayGames()+idx.getRemainingHomeGames() != 0){
		isOnAwayTrip[0] = 1;
	}else{
		isOnAwayTrip[0] = 0;
	}

	//sum(crit,x) == 1 if a critical subset has been chosen.
	rel(*this, costs == sum(c,x) + (isOnAwayTrip[0]*(1-sum(crit,x))*thd[0]));

	branch(*this, x, INT_VAR_NONE, INT_VAL_MAX);
}

minCostCollection::minCostCollection(bool share, minCostCollection& s) : MinimizeSpace(share, s) {
	x.update(*this, share, s.x);
	costs.update(*this, share, s.costs);
}

