//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include "Subset.h"
#include "DistanceMatrix.h"
#include "DisjointPatternDatabase/Index.h"

#ifndef findMinTravelDistance_h
#define findMinTravelDistance_h

class FindMinTravelDistance{
private:
	int numberOfTeams, lowerBound, upperBound;
	unsigned int counter;
	SubsetContainer* subsetContainer;
	int powerSetSize;
	int startingLocation;
	Subset* nextSub, *criticalSub;
	int dist, currentLoc;
	DistanceMatrix* d;
	int tmp;
	bool illegalSubset;

public:
	FindMinTravelDistance(){}
	FindMinTravelDistance(DistanceMatrix* d, int lowerBound, int upperBound);
	~FindMinTravelDistance();
	int findTeamsMinTravelDistance(const Index &idx, int currentTeam);

private:
	bool isCriticalSub(int currentTeam, const Index &idx);
	bool setNextSub(int currentTeam, bool* stillHasToPlayAway);
	bool nextSubset(int currentTeam, const Index &idx);
	int setStartingLocation(int currentTeam, const Index &idx);
};

#endif
